/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.web.session.HttpSessionCreatedEvent;
import org.springframework.security.web.session.HttpSessionDestroyedEvent;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HttpSessionEventPublisher
implements HttpSessionListener {
    private static final String LOGGER_NAME = HttpSessionEventPublisher.class.getName();

    ApplicationContext getContext(ServletContext servletContext) {
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
    }

    public void sessionCreated(HttpSessionEvent event) {
        HttpSessionCreatedEvent e = new HttpSessionCreatedEvent(event.getSession());
        Log log = LogFactory.getLog(LOGGER_NAME);
        if (log.isDebugEnabled()) {
            log.debug("Publishing event: " + e);
        }
        this.getContext(event.getSession().getServletContext()).publishEvent(e);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSessionDestroyedEvent e = new HttpSessionDestroyedEvent(event.getSession());
        Log log = LogFactory.getLog(LOGGER_NAME);
        if (log.isDebugEnabled()) {
            log.debug("Publishing event: " + e);
        }
        this.getContext(event.getSession().getServletContext()).publishEvent(e);
    }
}

