/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.autoscaling.model.AutoScalingInstanceDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeAutoScalingInstancesResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<AutoScalingInstanceDetails> autoScalingInstances;
    private String nextToken;

    public List<AutoScalingInstanceDetails> getAutoScalingInstances() {
        if (this.autoScalingInstances == null) {
            this.autoScalingInstances = new ListWithAutoConstructFlag();
            this.autoScalingInstances.setAutoConstruct(true);
        }
        return this.autoScalingInstances;
    }

    public void setAutoScalingInstances(Collection<AutoScalingInstanceDetails> autoScalingInstances) {
        if (autoScalingInstances == null) {
            this.autoScalingInstances = null;
            return;
        }
        ListWithAutoConstructFlag autoScalingInstancesCopy = new ListWithAutoConstructFlag(autoScalingInstances.size());
        autoScalingInstancesCopy.addAll(autoScalingInstances);
        this.autoScalingInstances = autoScalingInstancesCopy;
    }

    public DescribeAutoScalingInstancesResult withAutoScalingInstances(AutoScalingInstanceDetails ... autoScalingInstances) {
        if (this.getAutoScalingInstances() == null) {
            this.setAutoScalingInstances(new ArrayList<AutoScalingInstanceDetails>(autoScalingInstances.length));
        }
        for (AutoScalingInstanceDetails value : autoScalingInstances) {
            this.getAutoScalingInstances().add(value);
        }
        return this;
    }

    public DescribeAutoScalingInstancesResult withAutoScalingInstances(Collection<AutoScalingInstanceDetails> autoScalingInstances) {
        if (autoScalingInstances == null) {
            this.autoScalingInstances = null;
        } else {
            ListWithAutoConstructFlag autoScalingInstancesCopy = new ListWithAutoConstructFlag(autoScalingInstances.size());
            autoScalingInstancesCopy.addAll(autoScalingInstances);
            this.autoScalingInstances = autoScalingInstancesCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeAutoScalingInstancesResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoScalingInstances() != null) {
            sb.append("AutoScalingInstances: " + this.getAutoScalingInstances() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoScalingInstances() == null ? 0 : this.getAutoScalingInstances().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingInstancesResult)) {
            return false;
        }
        DescribeAutoScalingInstancesResult other = (DescribeAutoScalingInstancesResult)obj;
        if (other.getAutoScalingInstances() == null ^ this.getAutoScalingInstances() == null) {
            return false;
        }
        if (other.getAutoScalingInstances() != null && !other.getAutoScalingInstances().equals(this.getAutoScalingInstances())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public DescribeAutoScalingInstancesResult clone() {
        try {
            return (DescribeAutoScalingInstancesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

