/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.CreateIdentityPoolRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

public class CreateIdentityPoolRequestMarshaller
implements Marshaller<Request<CreateIdentityPoolRequest>, CreateIdentityPoolRequest> {
    @Override
    public Request<CreateIdentityPoolRequest> marshall(CreateIdentityPoolRequest createIdentityPoolRequest) {
        if (createIdentityPoolRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateIdentityPoolRequest> request = new DefaultRequest<CreateIdentityPoolRequest>(createIdentityPoolRequest, "AmazonCognitoIdentity");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityService.CreateIdentityPool");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> openIdConnectProviderARNsList;
            Map<String, String> supportedLoginProvidersMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createIdentityPoolRequest.getIdentityPoolName() != null) {
                jsonWriter.key("IdentityPoolName").value(createIdentityPoolRequest.getIdentityPoolName());
            }
            if (createIdentityPoolRequest.getAllowUnauthenticatedIdentities() != null) {
                jsonWriter.key("AllowUnauthenticatedIdentities").value(createIdentityPoolRequest.getAllowUnauthenticatedIdentities());
            }
            if ((supportedLoginProvidersMap = createIdentityPoolRequest.getSupportedLoginProviders()) != null) {
                jsonWriter.key("SupportedLoginProviders");
                jsonWriter.object();
                for (Map.Entry<String, String> supportedLoginProvidersMapValue : supportedLoginProvidersMap.entrySet()) {
                    if (supportedLoginProvidersMapValue.getValue() == null) continue;
                    jsonWriter.key(supportedLoginProvidersMapValue.getKey());
                    jsonWriter.value(supportedLoginProvidersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (createIdentityPoolRequest.getDeveloperProviderName() != null) {
                jsonWriter.key("DeveloperProviderName").value(createIdentityPoolRequest.getDeveloperProviderName());
            }
            if ((openIdConnectProviderARNsList = createIdentityPoolRequest.getOpenIdConnectProviderARNs()) != null) {
                jsonWriter.key("OpenIdConnectProviderARNs");
                jsonWriter.array();
                for (String openIdConnectProviderARNsListValue : openIdConnectProviderARNsList) {
                    if (openIdConnectProviderARNsListValue == null) continue;
                    jsonWriter.value(openIdConnectProviderARNsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

