/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpleemail.model.RawMessage;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class SendRawEmailRequestMarshaller
implements Marshaller<Request<SendRawEmailRequest>, SendRawEmailRequest> {
    @Override
    public Request<SendRawEmailRequest> marshall(SendRawEmailRequest sendRawEmailRequest) {
        if (sendRawEmailRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendRawEmailRequest> request = new DefaultRequest<SendRawEmailRequest>(sendRawEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendRawEmail");
        request.addParameter("Version", "2010-12-01");
        if (sendRawEmailRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(sendRawEmailRequest.getSource()));
        }
        List<String> destinationsList = sendRawEmailRequest.getDestinations();
        int destinationsListIndex = 1;
        for (String destinationsListValue : destinationsList) {
            if (destinationsListValue != null) {
                request.addParameter("Destinations.member." + destinationsListIndex, StringUtils.fromString(destinationsListValue));
            }
            ++destinationsListIndex;
        }
        RawMessage rawMessageRawMessage = sendRawEmailRequest.getRawMessage();
        if (rawMessageRawMessage != null && rawMessageRawMessage.getData() != null) {
            request.addParameter("RawMessage.Data", StringUtils.fromByteBuffer(rawMessageRawMessage.getData()));
        }
        if (sendRawEmailRequest.getFromArn() != null) {
            request.addParameter("FromArn", StringUtils.fromString(sendRawEmailRequest.getFromArn()));
        }
        if (sendRawEmailRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString(sendRawEmailRequest.getSourceArn()));
        }
        if (sendRawEmailRequest.getReturnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString(sendRawEmailRequest.getReturnPathArn()));
        }
        return request;
    }
}

