/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Endpoint
implements Serializable,
Cloneable {
    private String endpointArn;
    private Map<String, String> attributes;

    public String getEndpointArn() {
        return this.endpointArn;
    }

    public void setEndpointArn(String endpointArn) {
        this.endpointArn = endpointArn;
    }

    public Endpoint withEndpointArn(String endpointArn) {
        this.endpointArn = endpointArn;
        return this;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Endpoint withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public Endpoint addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public Endpoint clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointArn() != null) {
            sb.append("EndpointArn: " + this.getEndpointArn() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointArn() == null ? 0 : this.getEndpointArn().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (other.getEndpointArn() == null ^ this.getEndpointArn() == null) {
            return false;
        }
        if (other.getEndpointArn() != null && !other.getEndpointArn().equals(this.getEndpointArn())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public Endpoint clone() {
        try {
            return (Endpoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

