/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.workspaces.model.Workspace;
import com.amazonaws.util.json.JSONWriter;

public class WorkspaceJsonMarshaller {
    private static WorkspaceJsonMarshaller instance;

    public void marshall(Workspace workspace, JSONWriter jsonWriter) {
        if (workspace == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (workspace.getWorkspaceId() != null) {
                jsonWriter.key("WorkspaceId").value(workspace.getWorkspaceId());
            }
            if (workspace.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value(workspace.getDirectoryId());
            }
            if (workspace.getUserName() != null) {
                jsonWriter.key("UserName").value(workspace.getUserName());
            }
            if (workspace.getIpAddress() != null) {
                jsonWriter.key("IpAddress").value(workspace.getIpAddress());
            }
            if (workspace.getState() != null) {
                jsonWriter.key("State").value(workspace.getState());
            }
            if (workspace.getBundleId() != null) {
                jsonWriter.key("BundleId").value(workspace.getBundleId());
            }
            if (workspace.getSubnetId() != null) {
                jsonWriter.key("SubnetId").value(workspace.getSubnetId());
            }
            if (workspace.getErrorMessage() != null) {
                jsonWriter.key("ErrorMessage").value(workspace.getErrorMessage());
            }
            if (workspace.getErrorCode() != null) {
                jsonWriter.key("ErrorCode").value(workspace.getErrorCode());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WorkspaceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WorkspaceJsonMarshaller();
        }
        return instance;
    }
}

