/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.duracloud.common.collection.WriteOnlyStringSet;
import org.duracloud.common.constant.ManifestFormat;
import org.duracloud.manifest.impl.TsvManifestFormatter;
import org.duracloud.manifeststitch.StitchedManifestGenerator;
import org.duracloud.mill.db.model.ManifestItem;
import org.duracloud.snapshot.service.impl.ManifestFileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceManifestDpnManifestVerifier {
    private static final Logger log = LoggerFactory.getLogger(SpaceManifestDpnManifestVerifier.class);
    private File md5Manifest;
    private StitchedManifestGenerator generator;
    private String spaceId;
    private List<String> errors;

    public SpaceManifestDpnManifestVerifier(File md5Manifest, StitchedManifestGenerator generator, String spaceId) {
        this.md5Manifest = md5Manifest;
        this.generator = generator;
        this.spaceId = spaceId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public boolean verify() {
        this.errors = new LinkedList<String>();
        try {
            WriteOnlyStringSet dpnManifest = ManifestFileHelper.loadManifestSetFromFile(this.md5Manifest);
            log.info("loaded manifest set into memory.");
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.generator.generate(this.spaceId, ManifestFormat.TSV)));
            TsvManifestFormatter formatter = new TsvManifestFormatter();
            if (formatter.getHeader() != null) {
                reader.readLine();
            }
            String line = null;
            int stitchedManifestCount = 0;
            while ((line = reader.readLine()) != null) {
                ManifestItem item = formatter.parseLine(line);
                String contentId = item.getContentId();
                if (contentId.equals(".collection-snapshot.properties")) continue;
                if (!dpnManifest.contains(ManifestFileHelper.formatManifestSetString(contentId, item.getContentChecksum()))) {
                    String message = "DPN manifest does not contain content id/checksum combination (" + contentId + ", " + item.getContentChecksum();
                    this.errors.add(message);
                }
                ++stitchedManifestCount;
            }
            int dpnCount = dpnManifest.size();
            if (stitchedManifestCount != dpnCount) {
                String message = "DPN Manifest size (" + dpnCount + ") does not equal DuraCloud Manifest (" + stitchedManifestCount + ")";
                this.errors.add(message);
                log.error(message);
            }
        }
        catch (Exception e) {
            String message = "Failed to verify space manifest against dpn manifest:" + e.getMessage();
            this.errors.add(message);
            log.error(message, e);
        }
        log.info("verification complete. error count = {}", (Object)this.errors.size());
        return this.getResult(this.errors);
    }

    private boolean getResult(List<String> errors) {
        return errors.size() == 0;
    }

    public List<String> getErrors() {
        if (this.errors == null) {
            throw new IllegalStateException("You must call execute() before attempting to access the errors");
        }
        return this.errors;
    }
}

