/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.KeyValuePair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContainerOverride
implements Serializable,
Cloneable {
    private String name;
    private ListWithAutoConstructFlag<String> command;
    private ListWithAutoConstructFlag<KeyValuePair> environment;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContainerOverride withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> getCommand() {
        if (this.command == null) {
            this.command = new ListWithAutoConstructFlag();
            this.command.setAutoConstruct(true);
        }
        return this.command;
    }

    public void setCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
            return;
        }
        ListWithAutoConstructFlag commandCopy = new ListWithAutoConstructFlag(command.size());
        commandCopy.addAll(command);
        this.command = commandCopy;
    }

    public ContainerOverride withCommand(String ... command) {
        if (this.getCommand() == null) {
            this.setCommand(new ArrayList<String>(command.length));
        }
        for (String value : command) {
            this.getCommand().add(value);
        }
        return this;
    }

    public ContainerOverride withCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
        } else {
            ListWithAutoConstructFlag commandCopy = new ListWithAutoConstructFlag(command.size());
            commandCopy.addAll(command);
            this.command = commandCopy;
        }
        return this;
    }

    public List<KeyValuePair> getEnvironment() {
        if (this.environment == null) {
            this.environment = new ListWithAutoConstructFlag();
            this.environment.setAutoConstruct(true);
        }
        return this.environment;
    }

    public void setEnvironment(Collection<KeyValuePair> environment) {
        if (environment == null) {
            this.environment = null;
            return;
        }
        ListWithAutoConstructFlag environmentCopy = new ListWithAutoConstructFlag(environment.size());
        environmentCopy.addAll(environment);
        this.environment = environmentCopy;
    }

    public ContainerOverride withEnvironment(KeyValuePair ... environment) {
        if (this.getEnvironment() == null) {
            this.setEnvironment(new ArrayList<KeyValuePair>(environment.length));
        }
        for (KeyValuePair value : environment) {
            this.getEnvironment().add(value);
        }
        return this;
    }

    public ContainerOverride withEnvironment(Collection<KeyValuePair> environment) {
        if (environment == null) {
            this.environment = null;
        } else {
            ListWithAutoConstructFlag environmentCopy = new ListWithAutoConstructFlag(environment.size());
            environmentCopy.addAll(environment);
            this.environment = environmentCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: " + this.getCommand() + ",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: " + this.getEnvironment());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerOverride)) {
            return false;
        }
        ContainerOverride other = (ContainerOverride)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        return other.getEnvironment() == null || other.getEnvironment().equals(this.getEnvironment());
    }

    public ContainerOverride clone() {
        try {
            return (ContainerOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

