/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.services.elasticbeanstalk.model.ValidationSeverity;
import java.io.Serializable;

public class ValidationMessage
implements Serializable,
Cloneable {
    private String message;
    private String severity;
    private String namespace;
    private String optionName;

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public ValidationMessage withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getSeverity() {
        return this.severity;
    }

    public ValidationMessage withSeverity(String severity) {
        this.setSeverity(severity);
        return this;
    }

    public void setSeverity(ValidationSeverity severity) {
        this.severity = severity.toString();
    }

    public ValidationMessage withSeverity(ValidationSeverity severity) {
        this.setSeverity(severity);
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ValidationMessage withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setOptionName(String optionName) {
        this.optionName = optionName;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public ValidationMessage withOptionName(String optionName) {
        this.setOptionName(optionName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMessage() != null) {
            sb.append("Message: " + this.getMessage() + ",");
        }
        if (this.getSeverity() != null) {
            sb.append("Severity: " + this.getSeverity() + ",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: " + this.getNamespace() + ",");
        }
        if (this.getOptionName() != null) {
            sb.append("OptionName: " + this.getOptionName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationMessage)) {
            return false;
        }
        ValidationMessage other = (ValidationMessage)obj;
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getSeverity() == null ^ this.getSeverity() == null) {
            return false;
        }
        if (other.getSeverity() != null && !other.getSeverity().equals(this.getSeverity())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getOptionName() == null ^ this.getOptionName() == null) {
            return false;
        }
        return other.getOptionName() == null || other.getOptionName().equals(this.getOptionName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getSeverity() == null ? 0 : this.getSeverity().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getOptionName() == null ? 0 : this.getOptionName().hashCode());
        return hashCode;
    }

    public ValidationMessage clone() {
        try {
            return (ValidationMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

