/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.AddPermissionRequest;
import com.amazonaws.services.lambda.model.AddPermissionResult;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingResult;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionResult;
import com.amazonaws.services.lambda.model.DeleteEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.DeleteEventSourceMappingResult;
import com.amazonaws.services.lambda.model.DeleteFunctionRequest;
import com.amazonaws.services.lambda.model.GetEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.GetEventSourceMappingResult;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationResult;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.services.lambda.model.GetFunctionResult;
import com.amazonaws.services.lambda.model.GetPolicyRequest;
import com.amazonaws.services.lambda.model.GetPolicyResult;
import com.amazonaws.services.lambda.model.InvokeAsyncRequest;
import com.amazonaws.services.lambda.model.InvokeAsyncResult;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsRequest;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsResult;
import com.amazonaws.services.lambda.model.ListFunctionsRequest;
import com.amazonaws.services.lambda.model.ListFunctionsResult;
import com.amazonaws.services.lambda.model.RemovePermissionRequest;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingResult;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeResult;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationResult;
import com.amazonaws.services.lambda.model.transform.AddPermissionRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.AddPermissionResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.CodeStorageExceededExceptionUnmarshaller;
import com.amazonaws.services.lambda.model.transform.CreateEventSourceMappingRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.CreateEventSourceMappingResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.CreateFunctionRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.CreateFunctionResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.DeleteEventSourceMappingRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.DeleteEventSourceMappingResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.DeleteFunctionRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.GetEventSourceMappingRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.GetEventSourceMappingResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.GetFunctionConfigurationRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.GetFunctionConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.GetFunctionRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.GetFunctionResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.GetPolicyRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.GetPolicyResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.lambda.model.transform.InvalidRequestContentExceptionUnmarshaller;
import com.amazonaws.services.lambda.model.transform.InvokeAsyncRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.InvokeAsyncResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.InvokeRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.InvokeResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.ListEventSourceMappingsRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.ListEventSourceMappingsResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.ListFunctionsRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.ListFunctionsResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.PolicyLengthExceededExceptionUnmarshaller;
import com.amazonaws.services.lambda.model.transform.RemovePermissionRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.RequestTooLargeExceptionUnmarshaller;
import com.amazonaws.services.lambda.model.transform.ResourceConflictExceptionUnmarshaller;
import com.amazonaws.services.lambda.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.lambda.model.transform.ServiceExceptionUnmarshaller;
import com.amazonaws.services.lambda.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.lambda.model.transform.UnsupportedMediaTypeExceptionUnmarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateEventSourceMappingRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateEventSourceMappingResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateFunctionCodeRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateFunctionCodeResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateFunctionConfigurationRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateFunctionConfigurationResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSLambdaClient
extends AmazonWebServiceClient
implements AWSLambda {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSLambda.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AWSLambdaClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AWSLambdaClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSLambdaClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSLambdaClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AWSLambdaClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSLambdaClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSLambdaClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSLambdaClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AWSLambdaClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new ServiceExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new RequestTooLargeExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new UnsupportedMediaTypeExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new CodeStorageExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new TooManyRequestsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidRequestContentExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidParameterValueExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new PolicyLengthExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceConflictExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("lambda.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/lambda/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/lambda/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFunction(DeleteFunctionRequest deleteFunctionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFunctionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFunctionRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFunctionRequestMarshaller().marshall(super.beforeMarshalling(deleteFunctionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddPermissionResult addPermission(AddPermissionRequest addPermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addPermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddPermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddPermissionRequestMarshaller().marshall(super.beforeMarshalling(addPermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            AddPermissionResultJsonUnmarshaller unmarshaller = new AddPermissionResultJsonUnmarshaller();
            JsonResponseHandler<AddPermissionResult> responseHandler = new JsonResponseHandler<AddPermissionResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            AddPermissionResult addPermissionResult = (AddPermissionResult)response.getAwsResponse();
            return addPermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFunctionsResult listFunctions(ListFunctionsRequest listFunctionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFunctionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFunctionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFunctionsRequestMarshaller().marshall(super.beforeMarshalling(listFunctionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListFunctionsResultJsonUnmarshaller unmarshaller = new ListFunctionsResultJsonUnmarshaller();
            JsonResponseHandler<ListFunctionsResult> responseHandler = new JsonResponseHandler<ListFunctionsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListFunctionsResult listFunctionsResult = (ListFunctionsResult)response.getAwsResponse();
            return listFunctionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePermission(RemovePermissionRequest removePermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removePermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemovePermissionRequest> request = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemovePermissionRequestMarshaller().marshall(super.beforeMarshalling(removePermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFunctionResult createFunction(CreateFunctionRequest createFunctionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFunctionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFunctionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFunctionRequestMarshaller().marshall(super.beforeMarshalling(createFunctionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateFunctionResultJsonUnmarshaller unmarshaller = new CreateFunctionResultJsonUnmarshaller();
            JsonResponseHandler<CreateFunctionResult> responseHandler = new JsonResponseHandler<CreateFunctionResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateFunctionResult createFunctionResult = (CreateFunctionResult)response.getAwsResponse();
            return createFunctionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEventSourceMappingResult updateEventSourceMapping(UpdateEventSourceMappingRequest updateEventSourceMappingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEventSourceMappingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEventSourceMappingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEventSourceMappingRequestMarshaller().marshall(super.beforeMarshalling(updateEventSourceMappingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateEventSourceMappingResultJsonUnmarshaller unmarshaller = new UpdateEventSourceMappingResultJsonUnmarshaller();
            JsonResponseHandler<UpdateEventSourceMappingResult> responseHandler = new JsonResponseHandler<UpdateEventSourceMappingResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEventSourceMappingResult updateEventSourceMappingResult = (UpdateEventSourceMappingResult)response.getAwsResponse();
            return updateEventSourceMappingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public InvokeAsyncResult invokeAsync(InvokeAsyncRequest invokeAsyncRequest) {
        ExecutionContext executionContext = this.createExecutionContext(invokeAsyncRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InvokeAsyncRequest> request = null;
        Response response = null;
        InputStream isOrig = invokeAsyncRequest.getInvokeArgs();
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InvokeAsyncRequestMarshaller().marshall(super.beforeMarshalling(invokeAsyncRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            InvokeAsyncResultJsonUnmarshaller unmarshaller = new InvokeAsyncResultJsonUnmarshaller();
            JsonResponseHandler<InvokeAsyncResult> responseHandler = new JsonResponseHandler<InvokeAsyncResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            InvokeAsyncResult invokeAsyncResult = (InvokeAsyncResult)response.getAwsResponse();
            return invokeAsyncResult;
        }
        finally {
            invokeAsyncRequest.setInvokeArgs(isOrig);
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFunctionConfigurationResult updateFunctionConfiguration(UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFunctionConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFunctionConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFunctionConfigurationRequestMarshaller().marshall(super.beforeMarshalling(updateFunctionConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateFunctionConfigurationResultJsonUnmarshaller unmarshaller = new UpdateFunctionConfigurationResultJsonUnmarshaller();
            JsonResponseHandler<UpdateFunctionConfigurationResult> responseHandler = new JsonResponseHandler<UpdateFunctionConfigurationResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFunctionConfigurationResult updateFunctionConfigurationResult = (UpdateFunctionConfigurationResult)response.getAwsResponse();
            return updateFunctionConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvokeResult invoke(InvokeRequest invokeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(invokeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InvokeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InvokeRequestMarshaller().marshall(super.beforeMarshalling(invokeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            InvokeResultJsonUnmarshaller unmarshaller = new InvokeResultJsonUnmarshaller();
            JsonResponseHandler<InvokeResult> responseHandler = new JsonResponseHandler<InvokeResult>(unmarshaller);
            responseHandler.needsConnectionLeftOpen = true;
            response = this.invoke(request, responseHandler, executionContext);
            InvokeResult invokeResult = (InvokeResult)response.getAwsResponse();
            return invokeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPolicyResult getPolicy(GetPolicyRequest getPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPolicyRequestMarshaller().marshall(super.beforeMarshalling(getPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetPolicyResultJsonUnmarshaller unmarshaller = new GetPolicyResultJsonUnmarshaller();
            JsonResponseHandler<GetPolicyResult> responseHandler = new JsonResponseHandler<GetPolicyResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetPolicyResult getPolicyResult = (GetPolicyResult)response.getAwsResponse();
            return getPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventSourceMappingsResult listEventSourceMappings(ListEventSourceMappingsRequest listEventSourceMappingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEventSourceMappingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEventSourceMappingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEventSourceMappingsRequestMarshaller().marshall(super.beforeMarshalling(listEventSourceMappingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListEventSourceMappingsResultJsonUnmarshaller unmarshaller = new ListEventSourceMappingsResultJsonUnmarshaller();
            JsonResponseHandler<ListEventSourceMappingsResult> responseHandler = new JsonResponseHandler<ListEventSourceMappingsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListEventSourceMappingsResult listEventSourceMappingsResult = (ListEventSourceMappingsResult)response.getAwsResponse();
            return listEventSourceMappingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEventSourceMappingResult getEventSourceMapping(GetEventSourceMappingRequest getEventSourceMappingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEventSourceMappingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEventSourceMappingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEventSourceMappingRequestMarshaller().marshall(super.beforeMarshalling(getEventSourceMappingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetEventSourceMappingResultJsonUnmarshaller unmarshaller = new GetEventSourceMappingResultJsonUnmarshaller();
            JsonResponseHandler<GetEventSourceMappingResult> responseHandler = new JsonResponseHandler<GetEventSourceMappingResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetEventSourceMappingResult getEventSourceMappingResult = (GetEventSourceMappingResult)response.getAwsResponse();
            return getEventSourceMappingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFunctionConfigurationResult getFunctionConfiguration(GetFunctionConfigurationRequest getFunctionConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFunctionConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFunctionConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFunctionConfigurationRequestMarshaller().marshall(super.beforeMarshalling(getFunctionConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetFunctionConfigurationResultJsonUnmarshaller unmarshaller = new GetFunctionConfigurationResultJsonUnmarshaller();
            JsonResponseHandler<GetFunctionConfigurationResult> responseHandler = new JsonResponseHandler<GetFunctionConfigurationResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetFunctionConfigurationResult getFunctionConfigurationResult = (GetFunctionConfigurationResult)response.getAwsResponse();
            return getFunctionConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEventSourceMappingResult deleteEventSourceMapping(DeleteEventSourceMappingRequest deleteEventSourceMappingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEventSourceMappingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEventSourceMappingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEventSourceMappingRequestMarshaller().marshall(super.beforeMarshalling(deleteEventSourceMappingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteEventSourceMappingResultJsonUnmarshaller unmarshaller = new DeleteEventSourceMappingResultJsonUnmarshaller();
            JsonResponseHandler<DeleteEventSourceMappingResult> responseHandler = new JsonResponseHandler<DeleteEventSourceMappingResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteEventSourceMappingResult deleteEventSourceMappingResult = (DeleteEventSourceMappingResult)response.getAwsResponse();
            return deleteEventSourceMappingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEventSourceMappingResult createEventSourceMapping(CreateEventSourceMappingRequest createEventSourceMappingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createEventSourceMappingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateEventSourceMappingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateEventSourceMappingRequestMarshaller().marshall(super.beforeMarshalling(createEventSourceMappingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateEventSourceMappingResultJsonUnmarshaller unmarshaller = new CreateEventSourceMappingResultJsonUnmarshaller();
            JsonResponseHandler<CreateEventSourceMappingResult> responseHandler = new JsonResponseHandler<CreateEventSourceMappingResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateEventSourceMappingResult createEventSourceMappingResult = (CreateEventSourceMappingResult)response.getAwsResponse();
            return createEventSourceMappingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFunctionCodeResult updateFunctionCode(UpdateFunctionCodeRequest updateFunctionCodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFunctionCodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFunctionCodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFunctionCodeRequestMarshaller().marshall(super.beforeMarshalling(updateFunctionCodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateFunctionCodeResultJsonUnmarshaller unmarshaller = new UpdateFunctionCodeResultJsonUnmarshaller();
            JsonResponseHandler<UpdateFunctionCodeResult> responseHandler = new JsonResponseHandler<UpdateFunctionCodeResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFunctionCodeResult updateFunctionCodeResult = (UpdateFunctionCodeResult)response.getAwsResponse();
            return updateFunctionCodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFunctionResult getFunction(GetFunctionRequest getFunctionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFunctionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFunctionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFunctionRequestMarshaller().marshall(super.beforeMarshalling(getFunctionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetFunctionResultJsonUnmarshaller unmarshaller = new GetFunctionResultJsonUnmarshaller();
            JsonResponseHandler<GetFunctionResult> responseHandler = new JsonResponseHandler<GetFunctionResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetFunctionResult getFunctionResult = (GetFunctionResult)response.getAwsResponse();
            return getFunctionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public ListFunctionsResult listFunctions() throws AmazonServiceException, AmazonClientException {
        return this.listFunctions(new ListFunctionsRequest());
    }

    @Override
    public ListEventSourceMappingsResult listEventSourceMappings() throws AmazonServiceException, AmazonClientException {
        return this.listEventSourceMappings(new ListEventSourceMappingsRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        return result;
    }
}

