/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.logs.model.DeleteLogStreamRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DeleteLogStreamRequestMarshaller
implements Marshaller<Request<DeleteLogStreamRequest>, DeleteLogStreamRequest> {
    @Override
    public Request<DeleteLogStreamRequest> marshall(DeleteLogStreamRequest deleteLogStreamRequest) {
        if (deleteLogStreamRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteLogStreamRequest> request = new DefaultRequest<DeleteLogStreamRequest>(deleteLogStreamRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.DeleteLogStream");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (deleteLogStreamRequest.getLogGroupName() != null) {
                jsonWriter.key("logGroupName").value(deleteLogStreamRequest.getLogGroupName());
            }
            if (deleteLogStreamRequest.getLogStreamName() != null) {
                jsonWriter.key("logStreamName").value(deleteLogStreamRequest.getLogStreamName());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

