/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.support.model.Communication;
import com.amazonaws.services.support.model.RecentCaseCommunications;
import com.amazonaws.services.support.model.transform.CommunicationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class RecentCaseCommunicationsJsonMarshaller {
    private static RecentCaseCommunicationsJsonMarshaller instance;

    public void marshall(RecentCaseCommunications recentCaseCommunications, JSONWriter jsonWriter) {
        if (recentCaseCommunications == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            SdkInternalList communicationsList = (SdkInternalList)recentCaseCommunications.getCommunications();
            if (!communicationsList.isEmpty() || !communicationsList.isAutoConstruct()) {
                jsonWriter.key("communications");
                jsonWriter.array();
                for (Communication communicationsListValue : communicationsList) {
                    if (communicationsListValue == null) continue;
                    CommunicationJsonMarshaller.getInstance().marshall(communicationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (recentCaseCommunications.getNextToken() != null) {
                jsonWriter.key("nextToken").value(recentCaseCommunications.getNextToken());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecentCaseCommunicationsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecentCaseCommunicationsJsonMarshaller();
        }
        return instance;
    }
}

