/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.duracloud.common.retry.ExceptionHandler;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.snapshot.service.impl.SpaceManifestDpnManifestVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ExecutionContext;

public abstract class StepExecutionSupport
implements StepExecutionListener {
    private Logger log = LoggerFactory.getLogger(StepExecutionSupport.class);
    private StepExecution stepExecution;
    public static String ITEMS_READ_KEY = "lines.read";
    public static final String ERRORS_KEY = "errors";
    private boolean test = false;

    protected ExecutionContext getExecutionContext() {
        return this.stepExecution.getExecutionContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addError(String error) {
        StepExecution stepExecution = this.stepExecution;
        synchronized (stepExecution) {
            List<String> errors = this.getErrors();
            errors.add(error);
            this.getExecutionContext().put(ERRORS_KEY, errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void clearErrors() {
        StepExecution stepExecution = this.stepExecution;
        synchronized (stepExecution) {
            LinkedList errors = new LinkedList();
            this.getExecutionContext().put(ERRORS_KEY, errors);
        }
    }

    protected void resetContextState() {
        this.addToItemsRead(this.getItemsRead() * -1L);
        this.clearErrors();
    }

    protected List<String> getErrors() {
        LinkedList errors = (LinkedList)this.getExecutionContext().get(ERRORS_KEY);
        if (errors == null) {
            errors = new LinkedList();
        }
        return errors;
    }

    protected void addToItemsRead(long value) {
        this.addToLong(ITEMS_READ_KEY, value);
    }

    protected long getItemsRead() {
        return this.getLongValue(ITEMS_READ_KEY);
    }

    protected void skipLinesAlreadyRead(Iterator it) {
        long linesRead = this.getItemsRead();
        if (linesRead > 0L) {
            for (long i = 0L; i < linesRead; ++i) {
                if (!it.hasNext()) continue;
                it.next();
            }
        }
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    protected StepExecution getStepExecution() {
        return this.stepExecution;
    }

    protected void failExecution() {
        this.stepExecution.upgradeStatus(BatchStatus.FAILED);
        this.stepExecution.setTerminateOnly();
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        ExitStatus status = stepExecution.getExitStatus();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToLong(String key, long value) {
        StepExecution stepExecution = this.stepExecution;
        synchronized (stepExecution) {
            long currentValue = this.getLongValue(key);
            this.getExecutionContext().putLong(key, currentValue + value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLongValue(String key) {
        StepExecution stepExecution = this.stepExecution;
        synchronized (stepExecution) {
            return this.getExecutionContext().getLong(key, 0L);
        }
    }

    protected List<String> verifySpace(final SpaceManifestDpnManifestVerifier verifier) {
        LinkedList<String> errors = new LinkedList<String>();
        String spaceId = verifier.getSpaceId();
        boolean verified = false;
        try {
            verified = (Boolean)new Retrier(4, 60000, 2).execute(new Retriable(){

                @Override
                public Object retry() throws Exception {
                    boolean result = verifier.verify();
                    if (!result && !StepExecutionSupport.this.test) {
                        String message = "verification failed.  Retrying...";
                        StepExecutionSupport.this.log.warn(message);
                        throw new Exception(message);
                    }
                    return result;
                }
            }, new ExceptionHandler(){

                @Override
                public void handle(Exception ex) {
                    StepExecutionSupport.this.log.warn("failed to verify: " + ex.getMessage());
                }
            });
        }
        catch (Exception e) {
            String message = MessageFormat.format("unexpected error during space verification: step_execution_id={0} job_execution_id={1}  spaceId={2}: message={3}", this.stepExecution.getId(), this.stepExecution.getJobExecutionId(), spaceId, e.getMessage());
            this.log.error(message);
        }
        if (!verified) {
            for (String error : verifier.getErrors()) {
                errors.add(error);
            }
            errors.add(MessageFormat.format("space manifest does not match the dpn manifest: step_execution_id={0} job_execution_id={1}  spaceId={2}", this.stepExecution.getId(), this.stepExecution.getJobExecutionId(), spaceId));
        }
        return errors;
    }

    public void setIsTest() {
        this.test = true;
    }
}

