/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.jpa;

import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PersistenceException;
import org.hibernate.jpa.event.spi.jpa.ListenerFactory;

public class StandardListenerFactory
implements ListenerFactory {
    private final ConcurrentHashMap listenerInstances = new ConcurrentHashMap();

    @Override
    public <T> T buildListener(Class<T> listenerClass) {
        Object listenerInstance = this.listenerInstances.get(listenerClass);
        if (listenerInstance == null) {
            try {
                listenerInstance = listenerClass.newInstance();
            }
            catch (Exception e) {
                throw new PersistenceException("Unable to create instance of " + listenerClass.getName() + " as a JPA callback listener", e);
            }
            Object existing = this.listenerInstances.putIfAbsent(listenerClass, listenerInstance);
            if (existing != null) {
                listenerInstance = existing;
            }
        }
        return (T)listenerInstance;
    }

    @Override
    public void release() {
        this.listenerInstances.clear();
    }
}

