/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.springframework.batch.core.JobKeyGenerator;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;

public class DefaultJobKeyGenerator
implements JobKeyGenerator<JobParameters> {
    @Override
    public String generateKey(JobParameters source) {
        MessageDigest digest;
        Map<String, JobParameter> props = source.getParameters();
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(props.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            JobParameter jobParameter = props.get(key);
            if (!jobParameter.isIdentifying()) continue;
            String value = jobParameter.getValue() == null ? "" : jobParameter.toString();
            stringBuffer.append(key + "=" + value + ";");
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm not available.  Fatal (should be in the JDK).");
        }
        try {
            byte[] bytes = digest.digest(stringBuffer.toString().getBytes("UTF-8"));
            return String.format("%032x", new BigInteger(1, bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not available.  Fatal (should be in the JDK).");
        }
    }
}

