/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.jsr.configuration.support.BatchPropertyContext;
import org.springframework.batch.repeat.context.SynchronizedAttributeAccessor;
import org.springframework.util.Assert;

public class StepContext
extends SynchronizedAttributeAccessor {
    private StepExecution stepExecution;
    private Map<String, Set<Runnable>> callbacks = new HashMap<String, Set<Runnable>>();
    private BatchPropertyContext propertyContext = null;

    public StepContext(StepExecution stepExecution) {
        Assert.notNull(stepExecution, "A StepContext must have a non-null StepExecution");
        this.stepExecution = stepExecution;
    }

    public StepContext(StepExecution stepExecution, BatchPropertyContext propertyContext) {
        Assert.notNull(stepExecution, "A StepContext must have a non-null StepExecution");
        this.stepExecution = stepExecution;
        this.propertyContext = propertyContext;
    }

    public String getStepName() {
        return this.stepExecution.getStepName();
    }

    public String getJobName() {
        Assert.state(this.stepExecution.getJobExecution() != null, "StepExecution does not have a JobExecution");
        Assert.state(this.stepExecution.getJobExecution().getJobInstance() != null, "StepExecution does not have a JobInstance");
        return this.stepExecution.getJobExecution().getJobInstance().getJobName();
    }

    public Properties getSystemProperties() {
        return System.getProperties();
    }

    public Map<String, Object> getStepExecutionContext() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.stepExecution.getExecutionContext().entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, Object> getJobExecutionContext() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.stepExecution.getJobExecution().getExecutionContext().entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, Object> getJobParameters() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, JobParameter> entry : this.stepExecution.getJobParameters().getParameters().entrySet()) {
            result.put(entry.getKey(), entry.getValue().getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, Object> getPartitionPlan() {
        Map partitionPlanProperties = new HashMap();
        if (this.propertyContext != null) {
            Properties partitionProperties = this.propertyContext.getStepProperties(this.getStepName());
            partitionPlanProperties = partitionProperties;
        }
        return Collections.unmodifiableMap(partitionPlanProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestructionCallback(String name, Runnable callback) {
        Map<String, Set<Runnable>> map = this.callbacks;
        synchronized (map) {
            Set<Runnable> set = this.callbacks.get(name);
            if (set == null) {
                set = new HashSet<Runnable>();
                this.callbacks.put(name, set);
            }
            set.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterDestructionCallbacks(String name) {
        Map<String, Set<Runnable>> map = this.callbacks;
        synchronized (map) {
            this.callbacks.remove(name);
        }
    }

    @Override
    public Object removeAttribute(String name) {
        this.unregisterDestructionCallbacks(name);
        return super.removeAttribute(name);
    }

    public void close() {
        ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
        Map<String, Set<Runnable>> copy = Collections.unmodifiableMap(this.callbacks);
        for (Map.Entry<String, Set<Runnable>> entry : copy.entrySet()) {
            Set<Runnable> set = entry.getValue();
            for (Runnable callback : set) {
                if (callback == null) continue;
                try {
                    callback.run();
                }
                catch (RuntimeException t) {
                    errors.add(t);
                }
            }
        }
        if (errors.isEmpty()) {
            return;
        }
        Exception error = (Exception)errors.get(0);
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        throw new UnexpectedJobExecutionException("Could not close step context, rethrowing first of " + errors.size() + " exceptions.", error);
    }

    public StepExecution getStepExecution() {
        return this.stepExecution;
    }

    public String getId() {
        Assert.state(this.stepExecution.getId() != null, "StepExecution has no id.  It must be saved before it can be used in step scope.");
        return "execution#" + this.stepExecution.getId();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof StepContext)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        StepContext context = (StepContext)other;
        if (context.stepExecution == this.stepExecution) {
            return true;
        }
        return this.stepExecution.equals(context.stepExecution);
    }

    @Override
    public int hashCode() {
        return this.stepExecution.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + ", stepExecutionContext=" + this.getStepExecutionContext() + ", jobExecutionContext=" + this.getJobExecutionContext() + ", jobParameters=" + this.getJobParameters();
    }
}

