/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.orm;

import org.hibernate.SQLQuery;
import org.springframework.batch.item.database.orm.AbstractHibernateQueryProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HibernateNativeQueryProvider<E>
extends AbstractHibernateQueryProvider {
    private String sqlQuery;
    private Class<E> entityClass;

    @Override
    public SQLQuery createQuery() {
        if (this.isStatelessSession()) {
            return this.getStatelessSession().createSQLQuery(this.sqlQuery).addEntity(this.entityClass);
        }
        return this.getStatefulSession().createSQLQuery(this.sqlQuery).addEntity(this.entityClass);
    }

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public void setEntityClass(Class<E> entityClazz) {
        this.entityClass = entityClazz;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue(StringUtils.hasText(this.sqlQuery), "Native SQL query cannot be empty");
        Assert.notNull(this.entityClass, "Entity class cannot be NULL");
    }
}

