/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.util.List;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class PropertyReferenceException
extends RuntimeException {
    private static final long serialVersionUID = -5254424051438976570L;
    private static final String ERROR_TEMPLATE = "No property %s found for type %s!";
    private final String propertyName;
    private final TypeInformation<?> type;
    private final List<PropertyPath> alreadyResolvedPath;

    public PropertyReferenceException(String propertyName, TypeInformation<?> type, List<PropertyPath> alreadyResolvedPah) {
        Assert.hasText(propertyName);
        Assert.notNull(type);
        this.propertyName = propertyName;
        this.type = type;
        this.alreadyResolvedPath = alreadyResolvedPah;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public TypeInformation<?> getType() {
        return this.type;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder(String.format(ERROR_TEMPLATE, this.propertyName, this.type.getType().getSimpleName()));
        if (!this.alreadyResolvedPath.isEmpty()) {
            builder.append(" Traversed path: ").append(this.alreadyResolvedPath.get(0).toString()).append(".");
        }
        return builder.toString();
    }

    public PropertyPath getBaseProperty() {
        return this.alreadyResolvedPath.isEmpty() ? null : this.alreadyResolvedPath.get(this.alreadyResolvedPath.size() - 1);
    }

    public boolean hasDeeperResolutionDepthThan(PropertyReferenceException exception) {
        return this.alreadyResolvedPath.size() > exception.alreadyResolvedPath.size();
    }
}

