/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.support;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class SpringAutowiredAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements MergedBeanDefinitionPostProcessor,
PriorityOrdered,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Set<Class<? extends Annotation>> autowiredAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>();
    private String requiredParameterName = "required";
    private boolean requiredParameterValue = true;
    private int order = 0x7FFFFFFD;
    private ConfigurableListableBeanFactory beanFactory;
    private final Map<Class<?>, Constructor<?>[]> candidateConstructorsCache = new ConcurrentHashMap(64);
    private final Map<Class<?>, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap(64);

    public SpringAutowiredAnnotationBeanPostProcessor() {
        this.autowiredAnnotationTypes.add(Autowired.class);
        this.autowiredAnnotationTypes.add(Value.class);
        ClassLoader cl = SpringAutowiredAnnotationBeanPostProcessor.class.getClassLoader();
        try {
            this.autowiredAnnotationTypes.add(cl.loadClass("javax.inject.Inject"));
            this.logger.info("JSR-330 'javax.inject.Inject' annotation found and supported for autowiring");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void setAutowiredAnnotationType(Class<? extends Annotation> autowiredAnnotationType) {
        Assert.notNull(autowiredAnnotationType, "'autowiredAnnotationType' must not be null");
        this.autowiredAnnotationTypes.clear();
        this.autowiredAnnotationTypes.add(autowiredAnnotationType);
    }

    public void setAutowiredAnnotationTypes(Set<Class<? extends Annotation>> autowiredAnnotationTypes) {
        Assert.notEmpty(autowiredAnnotationTypes, "'autowiredAnnotationTypes' must not be empty");
        this.autowiredAnnotationTypes.clear();
        this.autowiredAnnotationTypes.addAll(autowiredAnnotationTypes);
    }

    public void setRequiredParameterName(String requiredParameterName) {
        this.requiredParameterName = requiredParameterName;
    }

    public void setRequiredParameterValue(boolean requiredParameterValue) {
        this.requiredParameterValue = requiredParameterValue;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("AutowiredAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory");
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Override
    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        if (beanType != null) {
            InjectionMetadata metadata = this.findAutowiringMetadata(beanType);
            metadata.checkConfigMembers(beanDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constructor<?>[] determineCandidateConstructors(Class<?> beanClass, String beanName) throws BeansException {
        Constructor<?>[] candidateConstructors = this.candidateConstructorsCache.get(beanClass);
        if (candidateConstructors == null) {
            Map<Class<?>, Constructor<?>[]> map = this.candidateConstructorsCache;
            synchronized (map) {
                candidateConstructors = this.candidateConstructorsCache.get(beanClass);
                if (candidateConstructors == null) {
                    Constructor<?>[] rawCandidates = beanClass.getDeclaredConstructors();
                    ArrayList candidates = new ArrayList(rawCandidates.length);
                    Constructor<?> requiredConstructor = null;
                    Constructor<?> defaultConstructor = null;
                    for (Constructor<?> candidate : rawCandidates) {
                        Annotation annotation = this.findAutowiredAnnotation(candidate);
                        if (annotation != null) {
                            if (requiredConstructor != null) {
                                throw new BeanCreationException("Invalid autowire-marked constructor: " + candidate + ". Found another constructor with 'required' Autowired annotation: " + requiredConstructor);
                            }
                            if (candidate.getParameterTypes().length == 0) {
                                throw new IllegalStateException("Autowired annotation requires at least one argument: " + candidate);
                            }
                            boolean required = this.determineRequiredStatus(annotation);
                            if (required) {
                                if (!candidates.isEmpty()) {
                                    throw new BeanCreationException("Invalid autowire-marked constructors: " + candidates + ". Found another constructor with 'required' Autowired annotation: " + requiredConstructor);
                                }
                                requiredConstructor = candidate;
                            }
                            candidates.add(candidate);
                            continue;
                        }
                        if (candidate.getParameterTypes().length != 0) continue;
                        defaultConstructor = candidate;
                    }
                    if (!candidates.isEmpty()) {
                        if (requiredConstructor == null && defaultConstructor != null) {
                            candidates.add(defaultConstructor);
                        }
                        candidateConstructors = candidates.toArray(new Constructor[candidates.size()]);
                    } else {
                        candidateConstructors = new Constructor[]{};
                    }
                    this.candidateConstructorsCache.put(beanClass, candidateConstructors);
                }
            }
        }
        return candidateConstructors.length > 0 ? candidateConstructors : null;
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.findAutowiringMetadata(bean.getClass());
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of autowired dependencies failed", ex);
        }
        return pvs;
    }

    public void processInjection(Object bean) throws BeansException {
        Class<?> clazz = bean.getClass();
        InjectionMetadata metadata = this.findAutowiringMetadata(clazz);
        try {
            metadata.inject(bean, null, null);
        }
        catch (Throwable ex) {
            throw new BeanCreationException("Injection of autowired dependencies failed for class [" + clazz + "]", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InjectionMetadata findAutowiringMetadata(Class<?> clazz) {
        InjectionMetadata metadata = this.injectionMetadataCache.get(clazz);
        if (metadata == null) {
            Map<Class<?>, InjectionMetadata> map = this.injectionMetadataCache;
            synchronized (map) {
                metadata = this.injectionMetadataCache.get(clazz);
                if (metadata == null) {
                    metadata = this.buildAutowiringMetadata(clazz);
                    this.injectionMetadataCache.put(clazz, metadata);
                }
            }
        }
        return metadata;
    }

    protected InjectionMetadata buildAutowiringMetadata(Class<?> clazz) {
        LinkedList<InjectionMetadata.InjectedElement> elements = new LinkedList<InjectionMetadata.InjectedElement>();
        Class<?> targetClass = clazz;
        do {
            LinkedList<InjectionMetadata.InjectedElement> currElements = new LinkedList<InjectionMetadata.InjectedElement>();
            for (Field field : targetClass.getDeclaredFields()) {
                Annotation annotation = this.findAutowiredAnnotation(field);
                if (annotation == null) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn("Autowired annotation is not supported on static fields: " + field);
                    continue;
                }
                boolean required = this.determineRequiredStatus(annotation);
                currElements.add(new AutowiredFieldElement(field, required));
            }
            for (AccessibleObject accessibleObject : targetClass.getDeclaredMethods()) {
                Annotation annotation;
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)accessibleObject);
                Annotation annotation2 = annotation = BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)accessibleObject, bridgedMethod) ? this.findAutowiredAnnotation(bridgedMethod) : this.findAutowiredAnnotation(accessibleObject);
                if (annotation == null || !((Method)accessibleObject).equals(ClassUtils.getMostSpecificMethod((Method)accessibleObject, clazz))) continue;
                if (Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn("Autowired annotation is not supported on static methods: " + accessibleObject);
                    continue;
                }
                if (((Method)accessibleObject).getParameterTypes().length == 0 && this.logger.isWarnEnabled()) {
                    this.logger.warn("Autowired annotation should be used on methods with actual parameters: " + accessibleObject);
                }
                boolean required = this.determineRequiredStatus(annotation);
                PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)accessibleObject);
                currElements.add(new AutowiredMethodElement((Method)accessibleObject, required, pd));
            }
            elements.addAll(0, currElements);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return new InjectionMetadata(clazz, elements);
    }

    protected Annotation findAutowiredAnnotation(AccessibleObject ao) {
        for (Class<? extends Annotation> type : this.autowiredAnnotationTypes) {
            Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)ao, type);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    protected <T> Map<String, T> findAutowireCandidates(Class<T> type) throws BeansException {
        if (this.beanFactory == null) {
            throw new IllegalStateException("No BeanFactory configured - override the getBeanOfType method or specify the 'beanFactory' property");
        }
        return BeanFactoryUtils.beansOfTypeIncludingAncestors(this.beanFactory, type);
    }

    protected boolean determineRequiredStatus(Annotation annotation) {
        try {
            Method method = ReflectionUtils.findMethod(annotation.annotationType(), this.requiredParameterName);
            if (method == null) {
                return true;
            }
            return this.requiredParameterValue == (Boolean)ReflectionUtils.invokeMethod(method, annotation);
        }
        catch (Exception ex) {
            return true;
        }
    }

    private void registerDependentBeans(String beanName, Set<String> autowiredBeanNames) {
        if (beanName != null) {
            for (String autowiredBeanName : autowiredBeanNames) {
                if (this.beanFactory.containsBean(autowiredBeanName)) {
                    this.beanFactory.registerDependentBean(autowiredBeanName, beanName);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Autowiring by type from bean name '" + beanName + "' to bean named '" + autowiredBeanName + "'");
            }
        }
    }

    private Object resolvedCachedArgument(String beanName, Object cachedArgument) {
        if (cachedArgument instanceof DependencyDescriptor) {
            DependencyDescriptor descriptor = (DependencyDescriptor)cachedArgument;
            TypeConverter typeConverter = this.beanFactory.getTypeConverter();
            return this.beanFactory.resolveDependency(descriptor, beanName, null, typeConverter);
        }
        if (cachedArgument instanceof RuntimeBeanReference) {
            return this.beanFactory.getBean(((RuntimeBeanReference)cachedArgument).getBeanName());
        }
        return cachedArgument;
    }

    private class AutowiredMethodElement
    extends InjectionMetadata.InjectedElement {
        private final boolean required;
        private volatile boolean cached;
        private volatile Object[] cachedMethodArguments;

        public AutowiredMethodElement(Method method, boolean required, PropertyDescriptor pd) {
            super(method, pd);
            this.cached = false;
            this.required = required;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            if (this.checkPropertySkipping(pvs)) {
                return;
            }
            Method method = (Method)this.member;
            try {
                Object[] arguments;
                if (this.cached) {
                    arguments = this.resolveCachedArguments(beanName);
                } else {
                    Class<?>[] paramTypes = method.getParameterTypes();
                    arguments = new Object[paramTypes.length];
                    DependencyDescriptor[] descriptors = new DependencyDescriptor[paramTypes.length];
                    LinkedHashSet<String> autowiredBeanNames = new LinkedHashSet<String>(paramTypes.length);
                    TypeConverter typeConverter = SpringAutowiredAnnotationBeanPostProcessor.this.beanFactory.getTypeConverter();
                    for (int i = 0; i < arguments.length; ++i) {
                        MethodParameter methodParam = new MethodParameter(method, i);
                        GenericTypeResolver.resolveParameterType(methodParam, bean.getClass());
                        descriptors[i] = new DependencyDescriptor(methodParam, this.required);
                        arguments[i] = SpringAutowiredAnnotationBeanPostProcessor.this.beanFactory.resolveDependency(descriptors[i], beanName, autowiredBeanNames, typeConverter);
                        if (arguments[i] != null || this.required) continue;
                        arguments = null;
                        break;
                    }
                    AutowiredMethodElement autowiredMethodElement = this;
                    synchronized (autowiredMethodElement) {
                        if (!this.cached) {
                            if (arguments != null) {
                                this.cachedMethodArguments = new Object[arguments.length];
                                for (int i = 0; i < arguments.length; ++i) {
                                    this.cachedMethodArguments[i] = descriptors[i];
                                }
                                SpringAutowiredAnnotationBeanPostProcessor.this.registerDependentBeans(beanName, autowiredBeanNames);
                                if (autowiredBeanNames.size() == paramTypes.length) {
                                    Iterator it = autowiredBeanNames.iterator();
                                    for (int i = 0; i < paramTypes.length; ++i) {
                                        String autowiredBeanName = (String)it.next();
                                        if (!SpringAutowiredAnnotationBeanPostProcessor.this.beanFactory.containsBean(autowiredBeanName) || !SpringAutowiredAnnotationBeanPostProcessor.this.beanFactory.isTypeMatch(autowiredBeanName, paramTypes[i])) continue;
                                        this.cachedMethodArguments[i] = new RuntimeBeanReference(autowiredBeanName);
                                    }
                                }
                            } else {
                                this.cachedMethodArguments = null;
                            }
                            this.cached = true;
                        }
                    }
                }
                if (arguments != null) {
                    ReflectionUtils.makeAccessible(method);
                    method.invoke(bean, arguments);
                }
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            catch (Throwable ex) {
                throw new BeanCreationException("Could not autowire method: " + method, ex);
            }
        }

        private Object[] resolveCachedArguments(String beanName) {
            if (this.cachedMethodArguments == null) {
                return null;
            }
            Object[] arguments = new Object[this.cachedMethodArguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = SpringAutowiredAnnotationBeanPostProcessor.this.resolvedCachedArgument(beanName, this.cachedMethodArguments[i]);
            }
            return arguments;
        }
    }

    private class AutowiredFieldElement
    extends InjectionMetadata.InjectedElement {
        private final boolean required;
        private volatile boolean cached;
        private volatile Object cachedFieldValue;

        public AutowiredFieldElement(Field field, boolean required) {
            super(field, null);
            this.cached = false;
            this.required = required;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            Field field = (Field)this.member;
            try {
                Object value;
                if (this.cached) {
                    value = SpringAutowiredAnnotationBeanPostProcessor.this.resolvedCachedArgument(beanName, this.cachedFieldValue);
                } else {
                    DependencyDescriptor descriptor = new DependencyDescriptor(field, this.required);
                    LinkedHashSet<String> autowiredBeanNames = new LinkedHashSet<String>(1);
                    TypeConverter typeConverter = SpringAutowiredAnnotationBeanPostProcessor.this.beanFactory.getTypeConverter();
                    value = SpringAutowiredAnnotationBeanPostProcessor.this.beanFactory.resolveDependency(descriptor, beanName, autowiredBeanNames, typeConverter);
                    AutowiredFieldElement autowiredFieldElement = this;
                    synchronized (autowiredFieldElement) {
                        if (!this.cached) {
                            if (value != null || this.required) {
                                this.cachedFieldValue = descriptor;
                                SpringAutowiredAnnotationBeanPostProcessor.this.registerDependentBeans(beanName, autowiredBeanNames);
                                if (autowiredBeanNames.size() == 1) {
                                    String autowiredBeanName = (String)autowiredBeanNames.iterator().next();
                                    if (SpringAutowiredAnnotationBeanPostProcessor.this.beanFactory.containsBean(autowiredBeanName) && SpringAutowiredAnnotationBeanPostProcessor.this.beanFactory.isTypeMatch(autowiredBeanName, field.getType())) {
                                        this.cachedFieldValue = new RuntimeBeanReference(autowiredBeanName);
                                    }
                                }
                            } else {
                                this.cachedFieldValue = null;
                            }
                            this.cached = true;
                        }
                    }
                }
                if (value != null) {
                    ReflectionUtils.makeAccessible(field);
                    field.set(bean, value);
                }
            }
            catch (Throwable ex) {
                throw new BeanCreationException("Could not autowire field: " + field, ex);
            }
        }
    }
}

