/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.duracloud.client.ContentStore;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.snapshot.SnapshotException;
import org.duracloud.snapshot.SnapshotNotFoundException;
import org.duracloud.snapshot.db.ContentDirUtils;
import org.duracloud.snapshot.db.model.BaseEntity;
import org.duracloud.snapshot.db.model.DuracloudEndPointConfig;
import org.duracloud.snapshot.db.model.Restoration;
import org.duracloud.snapshot.db.model.Snapshot;
import org.duracloud.snapshot.db.repo.RestoreRepo;
import org.duracloud.snapshot.db.repo.SnapshotRepo;
import org.duracloud.snapshot.dto.RestoreStatus;
import org.duracloud.snapshot.dto.SnapshotStatus;
import org.duracloud.snapshot.dto.task.CompleteCancelSnapshotTaskParameters;
import org.duracloud.snapshot.service.AlreadyInitializedException;
import org.duracloud.snapshot.service.EventLog;
import org.duracloud.snapshot.service.RestorationNotFoundException;
import org.duracloud.snapshot.service.SnapshotJobManager;
import org.duracloud.snapshot.service.SnapshotJobManagerConfig;
import org.duracloud.snapshot.service.impl.BatchJobBuilder;
import org.duracloud.snapshot.service.impl.BatchJobBuilderManager;
import org.duracloud.snapshot.service.impl.StoreClientHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.core.step.NoSuchStepException;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.core.step.tasklet.StoppableTasklet;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SnapshotJobManagerImpl
implements SnapshotJobManager {
    private static final Logger log = LoggerFactory.getLogger(SnapshotJobManagerImpl.class);
    private JobLauncher jobLauncher;
    private JobRepository jobRepository;
    private SnapshotRepo snapshotRepo;
    private RestoreRepo restoreRepo;
    private SnapshotJobManagerConfig config;
    private BatchJobBuilderManager builderManager;
    private StoreClientHelper storeClientHelper;
    private EventLog eventLog;

    @Autowired
    public SnapshotJobManagerImpl(SnapshotRepo snapshotRepo, RestoreRepo restoreRepo, JobLauncher jobLauncher, JobRepository jobRepository, BatchJobBuilderManager manager, StoreClientHelper storeClientHelper, EventLog eventLog) {
        this.restoreRepo = restoreRepo;
        this.snapshotRepo = snapshotRepo;
        this.builderManager = manager;
        this.jobLauncher = jobLauncher;
        this.jobRepository = jobRepository;
        this.storeClientHelper = storeClientHelper;
        this.eventLog = eventLog;
    }

    @Override
    public void init(SnapshotJobManagerConfig config) throws AlreadyInitializedException {
        this.init(config, true);
    }

    protected void init(SnapshotJobManagerConfig config, boolean attemptRestart) throws AlreadyInitializedException {
        if (this.isInitialized()) {
            throw new AlreadyInitializedException("Already initialized!");
        }
        this.config = config;
        log.info("initialized successfully.");
        if (attemptRestart) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SnapshotJobManagerImpl.this.restartIncompleteJobs();
                    }
                    catch (Exception e) {
                        log.error("failed to restart all incomplete jobs:" + e.getMessage(), e);
                    }
                }
            }).start();
        }
    }

    private void restartIncompleteJobs() throws Exception {
        log.info("checking for incomplete snapshot jobs.");
        this.resumeByStatus(SnapshotStatus.TRANSFERRING_FROM_DURACLOUD);
        this.resumeByStatus(SnapshotStatus.INITIALIZED);
        log.info("checking for incomplete restore jobs.");
        for (Restoration restore : this.restoreRepo.findRunning()) {
            try {
                this.resumeJob("restore", restore);
            }
            catch (SnapshotException ex) {
                log.error("unable to resume restore " + restore, ex);
            }
        }
    }

    private void resumeByStatus(SnapshotStatus status) {
        for (Snapshot snapshot : this.snapshotRepo.findByStatus(status)) {
            try {
                this.resumeJob("snapshot", snapshot);
            }
            catch (SnapshotException ex) {
                log.error("unable to resume snapshot " + snapshot, ex);
            }
        }
    }

    private void resumeJob(String jobName, Object entity) throws SnapshotException {
        BatchJobBuilder builder = this.builderManager.getBuilder(entity);
        Job job = builder.buildJob(entity, this.config);
        JobParameters params = builder.buildIdentifyingJobParameters(entity);
        JobExecution jobExecution = this.jobRepository.getLastJobExecution(jobName, params);
        if (jobExecution != null) {
            if (!jobExecution.getStatus().isRunning()) {
                return;
            }
            log.debug("found job execution in running state for {} (job execution = {})", entity, (Object)jobExecution);
            jobExecution.setStatus(BatchStatus.STOPPED);
            jobExecution.setEndTime(new Date());
            this.jobRepository.update(jobExecution);
            log.info("updated job execution in running state to stopped: {} (job execution = {})", entity, (Object)jobExecution);
        }
        try {
            JobExecution execution = this.jobLauncher.run(job, params);
            log.info("restarted job execution = {} for {}:  newly executed job execution id = {}", execution, entity, execution.getId());
        }
        catch (JobParametersInvalidException | JobExecutionAlreadyRunningException | JobInstanceAlreadyCompleteException | JobRestartException e) {
            log.error(MessageFormat.format("failed to resume stopped job: jobExecution={0}, entity={1}: {2}", jobExecution, entity, e.getMessage()), e);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.config != null;
    }

    private Snapshot getSnapshot(String snapshotId) throws SnapshotNotFoundException {
        Snapshot snapshot = this.snapshotRepo.findByName(snapshotId);
        if (snapshot == null) {
            throw new SnapshotNotFoundException(snapshotId);
        }
        return snapshot;
    }

    private BatchStatus executeJob(Object entity) throws SnapshotException {
        log.debug("executing job for {}", entity);
        try {
            BatchJobBuilder builder = this.builderManager.getBuilder(entity);
            Job job = builder.buildJob(entity, this.config);
            JobParameters params = builder.buildJobParameters(entity);
            JobExecution execution = this.jobLauncher.run(job, params);
            BatchStatus status = execution.getStatus();
            log.info("executed  {} using parameters {}: jobexecution={}, execution status={}", new Object[]{job, params, execution, status});
            return status;
        }
        catch (Exception e) {
            String message = "Error running job based on " + entity + ": " + e.getMessage();
            log.error(message, e);
            throw new SnapshotException(e.getMessage(), e);
        }
    }

    @Override
    public BatchStatus executeRestoration(String restorationId) throws SnapshotException {
        return this.executeJob(this.getRestoration(restorationId));
    }

    private Restoration getRestoration(String restorationId) throws RestorationNotFoundException {
        Restoration restoration = this.restoreRepo.findByRestorationId(restorationId);
        if (restoration == null) {
            throw new RestorationNotFoundException(restorationId);
        }
        return restoration;
    }

    @Override
    public BatchStatus executeSnapshot(String snapshotId) throws SnapshotException {
        this.checkInitialized();
        return this.executeJob(this.getSnapshot(snapshotId));
    }

    private boolean stop(JobExecution jobExecution, Job job) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        BatchStatus status = jobExecution.getStatus();
        if (status != BatchStatus.STARTED && status != BatchStatus.STARTING) {
            throw new JobExecutionNotRunningException("JobExecution must be running so that it can be stopped: " + jobExecution);
        }
        jobExecution.setStatus(BatchStatus.STOPPING);
        this.jobRepository.update(jobExecution);
        for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
            if (!stepExecution.getStatus().isRunning()) continue;
            try {
                Tasklet tasklet;
                Step step = ((StepLocator)((Object)job)).getStep(stepExecution.getStepName());
                if (!(step instanceof TaskletStep) || !((tasklet = ((TaskletStep)step).getTasklet()) instanceof StoppableTasklet)) continue;
                StepSynchronizationManager.register(stepExecution);
                ((StoppableTasklet)tasklet).stop();
                StepSynchronizationManager.release();
            }
            catch (NoSuchStepException e) {
                log.warn("Step not found", e);
            }
        }
        return true;
    }

    @Override
    @Transactional
    public void cancelSnapshot(String snapshotId) throws SnapshotException {
        this.checkInitialized();
        final Snapshot snapshot = this.getSnapshot(snapshotId);
        this.stop(snapshot);
        String snapshotDir = ContentDirUtils.getDestinationPath(snapshotId, this.config.getContentRootDir());
        this.deleteDirectory(snapshotDir);
        new Thread(new Runnable(){

            @Override
            public void run() {
                DuracloudEndPointConfig source = snapshot.getSource();
                final String spaceId = source.getSpaceId();
                final ContentStore contentStore = SnapshotJobManagerImpl.this.storeClientHelper.create(source, SnapshotJobManagerImpl.this.config.getDuracloudUsername(), SnapshotJobManagerImpl.this.config.getDuracloudPassword());
                try {
                    String result = (String)new Retrier().execute(new Retriable(){

                        @Override
                        public Object retry() throws Exception {
                            CompleteCancelSnapshotTaskParameters params = new CompleteCancelSnapshotTaskParameters();
                            params.setSpaceId(spaceId);
                            return contentStore.performTask("complete-cancel-snapshot", params.serialize());
                        }
                    });
                    log.info("snapshot cancellation is complete: {}", (Object)result);
                    snapshot.setStatus(SnapshotStatus.CANCELLED);
                    snapshot.setStatusText("");
                    SnapshotJobManagerImpl.this.eventLog.logSnapshotUpdate(snapshot);
                }
                catch (Exception ex) {
                    log.error("failed to complete cancellation on the durastore side for space {}:  {}", spaceId, ex.getMessage(), ex);
                }
            }
        }).start();
    }

    @Override
    @Transactional
    public Restoration stopRestore(String restoreId) throws SnapshotException {
        return this.stopRestoreInternal(restoreId);
    }

    @Override
    @Transactional
    public void cancelRestore(String restoreId) throws SnapshotException {
        this.checkInitialized();
        final Restoration restore = this.stopRestoreInternal(restoreId);
        String restoreDir = ContentDirUtils.getSourcePath(restoreId, this.config.getContentRootDir());
        this.deleteDirectory(restoreDir);
        final DuracloudEndPointConfig destination = restore.getDestination();
        new Thread(new Runnable(){

            @Override
            public void run() {
                final String spaceId = destination.getSpaceId();
                final ContentStore contentStore = SnapshotJobManagerImpl.this.storeClientHelper.create(destination, SnapshotJobManagerImpl.this.config.getDuracloudUsername(), SnapshotJobManagerImpl.this.config.getDuracloudPassword());
                try {
                    String result = (String)new Retrier().execute(new Retriable(){

                        @Override
                        public Object retry() throws Exception {
                            contentStore.deleteSpace(spaceId);
                            return null;
                        }
                    });
                    log.info("restore cancellation is complete: {}", (Object)result);
                    restore.setStatus(RestoreStatus.CANCELLED);
                    restore.setStatusText("");
                    SnapshotJobManagerImpl.this.eventLog.logRestoreUpdate(restore);
                }
                catch (Exception ex) {
                    log.error("failed to delete restore space {} as part of cleanup:  {}", spaceId, ex.getMessage(), ex);
                }
            }
        }).start();
    }

    private Restoration stopRestoreInternal(String restoreId) throws SnapshotException {
        Restoration restore = this.getRestoration(restoreId);
        this.stop(restore);
        return restore;
    }

    private void stop(BaseEntity entity) throws SnapshotException {
        JobExecution execution = this.getJobExecution(entity);
        if (execution == null) {
            log.info("no job executions associated with {}", (Object)entity);
            return;
        }
        Job job = this.builderManager.getBuilder(entity).buildJob(entity, this.config);
        try {
            this.stop(execution, job);
        }
        catch (NoSuchJobExecutionException e1) {
            log.warn("job execution not found: " + e1.getMessage());
        }
        catch (JobExecutionNotRunningException e1) {
            log.warn("job execution not running: " + e1.getMessage());
        }
    }

    private void deleteDirectory(String path) {
        log.info("deleting restore dir: {}", (Object)path);
        File dir = new File(path);
        if (!dir.exists()) {
            log.info("nothing to delete: {} does not exist.", (Object)path);
        } else {
            boolean success = FileUtils.deleteQuietly(dir);
            log.info("deleted dir {}: success={}", (Object)path, (Object)success);
        }
    }

    private void checkInitialized() throws SnapshotException {
        if (!this.isInitialized()) {
            throw new SnapshotException("The application must be initialized before it can be invoked!", null);
        }
    }

    @Override
    public BatchStatus getStatus(String snapshotId) throws SnapshotNotFoundException, SnapshotException {
        this.checkInitialized();
        JobExecution ex = this.getJobExecution(this.snapshotRepo.findByName(snapshotId));
        if (ex == null) {
            return BatchStatus.UNKNOWN;
        }
        return ex.getStatus();
    }

    private JobExecution getJobExecution(BaseEntity entity) {
        BatchJobBuilder builder = this.builderManager.getBuilder(entity);
        JobParameters params = builder.buildIdentifyingJobParameters(entity);
        String jobName = builder.getJobName();
        JobExecution ex = this.jobRepository.getLastJobExecution(jobName, params);
        return ex;
    }
}

