/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.endpoint;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.duracloud.sync.endpoint.EndPointListener;
import org.duracloud.sync.endpoint.MonitoredFile;
import org.duracloud.sync.endpoint.MonitoredInputStream;
import org.duracloud.sync.endpoint.SyncEndpoint;
import org.duracloud.sync.endpoint.SyncResultType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemSyncEndpoint
implements SyncEndpoint {
    private final Logger logger = LoggerFactory.getLogger(FileSystemSyncEndpoint.class);
    private File syncToDir;
    private boolean syncDeletes;

    public FileSystemSyncEndpoint(File syncToDir, boolean syncDeletes) {
        this.syncToDir = syncToDir;
        this.syncDeletes = syncDeletes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean syncFile(MonitoredFile syncFile, File watchDir) {
        boolean success;
        block5: {
            File syncToFile;
            block6: {
                success = false;
                syncToFile = this.getSyncToFile(syncFile, watchDir);
                this.logger.info("Syncing file: " + syncFile.getAbsolutePath() + "\n   to " + syncToFile.getAbsolutePath());
                if (!syncFile.exists()) break block6;
                MonitoredInputStream inStream = null;
                FileOutputStream outStream = null;
                try {
                    if (!syncToFile.getParentFile().exists()) {
                        this.createParentDir(syncToFile.getParentFile());
                    }
                    inStream = syncFile.getStream();
                    outStream = new FileOutputStream(syncToFile);
                    IOUtils.copy((InputStream)inStream, (OutputStream)outStream);
                    success = true;
                }
                catch (IOException e) {
                    try {
                        this.logger.error("Unable to sync updated file " + syncFile.getAbsolutePath() + " to " + syncToFile.getAbsolutePath() + " due to " + e.getMessage(), e);
                        success = false;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inStream);
                        IOUtils.closeQuietly(outStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(inStream);
                    IOUtils.closeQuietly(outStream);
                    break block5;
                }
                IOUtils.closeQuietly(inStream);
                IOUtils.closeQuietly(outStream);
                break block5;
            }
            success = this.syncDeletes ? syncToFile.delete() : true;
        }
        return success;
    }

    @Override
    public SyncResultType syncFileAndReturnDetailedResult(MonitoredFile monitoredFile, File watchDir) {
        throw new UnsupportedOperationException();
    }

    private synchronized void createParentDir(File parentDir) {
        parentDir.mkdir();
    }

    protected File getSyncToFile(MonitoredFile syncFile, File watchDir) {
        File syncToFile;
        if (null == watchDir) {
            syncToFile = new File(this.syncToDir, syncFile.getName());
        } else {
            URI relativeFileURI = watchDir.toURI().relativize(syncFile.toURI());
            syncToFile = new File(this.syncToDir, relativeFileURI.getPath());
        }
        return syncToFile;
    }

    @Override
    public Iterator<String> getFilesList() {
        ArrayList<String> filesList = new ArrayList<String>();
        this.getFilesRelative(filesList, this.syncToDir);
        return filesList.iterator();
    }

    private void getFilesRelative(List<String> filesList, File dir) {
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    this.getFilesRelative(filesList, file);
                    continue;
                }
                filesList.add(this.getRelativeFilePath(file));
            }
        }
    }

    private String getRelativeFilePath(File file) {
        return this.syncToDir.toURI().relativize(file.toURI()).getPath();
    }

    @Override
    public void addEndPointListener(EndPointListener listener) {
    }

    @Override
    public void removeEndPointListener(EndPointListener listener) {
    }

    @Override
    public void deleteContent(String spaceId, String contentId) {
    }
}

