/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.util.Assert;

public class SimpleJobRepository
implements JobRepository {
    private static final Log logger = LogFactory.getLog(SimpleJobRepository.class);
    private JobInstanceDao jobInstanceDao;
    private JobExecutionDao jobExecutionDao;
    private StepExecutionDao stepExecutionDao;
    private ExecutionContextDao ecDao;

    SimpleJobRepository() {
    }

    public SimpleJobRepository(JobInstanceDao jobInstanceDao, JobExecutionDao jobExecutionDao, StepExecutionDao stepExecutionDao, ExecutionContextDao ecDao) {
        this.jobInstanceDao = jobInstanceDao;
        this.jobExecutionDao = jobExecutionDao;
        this.stepExecutionDao = stepExecutionDao;
        this.ecDao = ecDao;
    }

    @Override
    public boolean isJobInstanceExists(String jobName, JobParameters jobParameters) {
        return this.jobInstanceDao.getJobInstance(jobName, jobParameters) != null;
    }

    @Override
    public JobExecution createJobExecution(String jobName, JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        ExecutionContext executionContext;
        Assert.notNull(jobName, "Job name must not be null.");
        Assert.notNull(jobParameters, "JobParameters must not be null.");
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobName, jobParameters);
        if (jobInstance != null) {
            List<JobExecution> executions = this.jobExecutionDao.findJobExecutions(jobInstance);
            for (JobExecution execution : executions) {
                if (execution.isRunning()) {
                    throw new JobExecutionAlreadyRunningException("A job execution for this job is already running: " + jobInstance);
                }
                BatchStatus status = execution.getStatus();
                if (execution.getJobParameters().getParameters().size() <= 0 || status != BatchStatus.COMPLETED && status != BatchStatus.ABANDONED) continue;
                throw new JobInstanceAlreadyCompleteException("A job instance already exists and is complete for parameters=" + jobParameters + ".  If you want to run this job again, change the parameters.");
            }
            executionContext = this.ecDao.getExecutionContext(this.jobExecutionDao.getLastJobExecution(jobInstance));
        } else {
            jobInstance = this.jobInstanceDao.createJobInstance(jobName, jobParameters);
            executionContext = new ExecutionContext();
        }
        JobExecution jobExecution = new JobExecution(jobInstance, jobParameters, null);
        jobExecution.setExecutionContext(executionContext);
        jobExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.jobExecutionDao.saveJobExecution(jobExecution);
        this.ecDao.saveExecutionContext(jobExecution);
        return jobExecution;
    }

    @Override
    public void update(JobExecution jobExecution) {
        Assert.notNull(jobExecution, "JobExecution cannot be null.");
        Assert.notNull(jobExecution.getJobId(), "JobExecution must have a Job ID set.");
        Assert.notNull(jobExecution.getId(), "JobExecution must be already saved (have an id assigned).");
        jobExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.jobExecutionDao.synchronizeStatus(jobExecution);
        this.jobExecutionDao.updateJobExecution(jobExecution);
    }

    @Override
    public void add(StepExecution stepExecution) {
        this.validateStepExecution(stepExecution);
        stepExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.stepExecutionDao.saveStepExecution(stepExecution);
        this.ecDao.saveExecutionContext(stepExecution);
    }

    @Override
    public void addAll(Collection<StepExecution> stepExecutions) {
        Assert.notNull(stepExecutions, "Attempt to save a null collection of step executions");
        for (StepExecution stepExecution : stepExecutions) {
            this.validateStepExecution(stepExecution);
            stepExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        }
        this.stepExecutionDao.saveStepExecutions(stepExecutions);
        this.ecDao.saveExecutionContexts(stepExecutions);
    }

    @Override
    public void update(StepExecution stepExecution) {
        this.validateStepExecution(stepExecution);
        Assert.notNull(stepExecution.getId(), "StepExecution must already be saved (have an id assigned)");
        stepExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.stepExecutionDao.updateStepExecution(stepExecution);
        this.checkForInterruption(stepExecution);
    }

    private void validateStepExecution(StepExecution stepExecution) {
        Assert.notNull(stepExecution, "StepExecution cannot be null.");
        Assert.notNull(stepExecution.getStepName(), "StepExecution's step name cannot be null.");
        Assert.notNull(stepExecution.getJobExecutionId(), "StepExecution must belong to persisted JobExecution");
    }

    @Override
    public void updateExecutionContext(StepExecution stepExecution) {
        this.validateStepExecution(stepExecution);
        Assert.notNull(stepExecution.getId(), "StepExecution must already be saved (have an id assigned)");
        this.ecDao.updateExecutionContext(stepExecution);
    }

    @Override
    public void updateExecutionContext(JobExecution jobExecution) {
        this.ecDao.updateExecutionContext(jobExecution);
    }

    @Override
    public StepExecution getLastStepExecution(JobInstance jobInstance, String stepName) {
        List<JobExecution> jobExecutions = this.jobExecutionDao.findJobExecutions(jobInstance);
        ArrayList<StepExecution> stepExecutions = new ArrayList<StepExecution>(jobExecutions.size());
        for (JobExecution jobExecution : jobExecutions) {
            this.stepExecutionDao.addStepExecutions(jobExecution);
            for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
                if (!stepName.equals(stepExecution.getStepName())) continue;
                stepExecutions.add(stepExecution);
            }
        }
        StepExecution latest = null;
        for (StepExecution stepExecution : stepExecutions) {
            if (latest == null) {
                latest = stepExecution;
            }
            if (latest.getStartTime().getTime() >= stepExecution.getStartTime().getTime()) continue;
            latest = stepExecution;
        }
        if (latest != null) {
            ExecutionContext stepExecutionContext = this.ecDao.getExecutionContext(latest);
            latest.setExecutionContext(stepExecutionContext);
            ExecutionContext jobExecutionContext = this.ecDao.getExecutionContext(latest.getJobExecution());
            latest.getJobExecution().setExecutionContext(jobExecutionContext);
        }
        return latest;
    }

    @Override
    public int getStepExecutionCount(JobInstance jobInstance, String stepName) {
        int count = 0;
        List<JobExecution> jobExecutions = this.jobExecutionDao.findJobExecutions(jobInstance);
        for (JobExecution jobExecution : jobExecutions) {
            this.stepExecutionDao.addStepExecutions(jobExecution);
            for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
                if (!stepName.equals(stepExecution.getStepName())) continue;
                ++count;
            }
        }
        return count;
    }

    private void checkForInterruption(StepExecution stepExecution) {
        JobExecution jobExecution = stepExecution.getJobExecution();
        this.jobExecutionDao.synchronizeStatus(jobExecution);
        if (jobExecution.isStopping()) {
            logger.info("Parent JobExecution is stopped, so passing message on to StepExecution");
            stepExecution.setTerminateOnly();
        }
    }

    @Override
    public JobExecution getLastJobExecution(String jobName, JobParameters jobParameters) {
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobName, jobParameters);
        if (jobInstance == null) {
            return null;
        }
        JobExecution jobExecution = this.jobExecutionDao.getLastJobExecution(jobInstance);
        if (jobExecution != null) {
            jobExecution.setExecutionContext(this.ecDao.getExecutionContext(jobExecution));
            this.stepExecutionDao.addStepExecutions(jobExecution);
        }
        return jobExecution;
    }

    @Override
    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Assert.notNull(jobName, "A job name is required to create a JobInstance");
        Assert.notNull(jobParameters, "Job parameters are required to create a JobInstance");
        JobInstance jobInstance = this.jobInstanceDao.createJobInstance(jobName, jobParameters);
        return jobInstance;
    }

    @Override
    public JobExecution createJobExecution(JobInstance jobInstance, JobParameters jobParameters, String jobConfigurationLocation) {
        Assert.notNull(jobInstance, "A JobInstance is required to associate the JobExecution with");
        Assert.notNull(jobParameters, "A JobParameters object is required to create a JobExecution");
        JobExecution jobExecution = new JobExecution(jobInstance, jobParameters, jobConfigurationLocation);
        ExecutionContext executionContext = new ExecutionContext();
        jobExecution.setExecutionContext(executionContext);
        jobExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.jobExecutionDao.saveJobExecution(jobExecution);
        this.ecDao.saveExecutionContext(jobExecution);
        return jobExecution;
    }
}

