/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.Assert;

public class ResultProcessor {
    private final QueryMethod method;
    private final ProjectingConverter converter;
    private final ProjectionFactory factory;
    private ReturnedType type;

    ResultProcessor(QueryMethod method, ProjectionFactory factory) {
        this(method, factory, method.getReturnedObjectType());
    }

    private ResultProcessor(QueryMethod method, ProjectionFactory factory, Class<?> type) {
        Assert.notNull(method, "QueryMethod must not be null!");
        Assert.notNull(factory, "ProjectionFactory must not be null!");
        Assert.notNull(type, "Type must not be null!");
        this.method = method;
        this.type = ReturnedType.of(type, method.getDomainClass(), factory);
        this.converter = new ProjectingConverter(this.type, factory);
        this.factory = factory;
    }

    public ResultProcessor withDynamicProjection(ParameterAccessor accessor) {
        if (accessor == null) {
            return this;
        }
        Class<?> projectionType = accessor.getDynamicProjection();
        return projectionType == null ? this : new ResultProcessor(this.method, this.factory, projectionType);
    }

    public ReturnedType getReturnedType() {
        return this.type;
    }

    public <T> T processResult(Object source) {
        return this.processResult(source, NoOpConverter.INSTANCE);
    }

    public <T> T processResult(Object source, Converter<Object, Object> preparingConverter) {
        if (source == null || this.type.isInstance(source) || !this.type.isProjecting()) {
            return (T)source;
        }
        Assert.notNull(preparingConverter, "Preparing converter must not be null!");
        ChainingConverter converter = ChainingConverter.of(this.type.getReturnedType(), preparingConverter).and(this.converter);
        if (source instanceof Page && this.method.isPageQuery()) {
            return (T)((Page)source).map(converter);
        }
        if (source instanceof Collection && this.method.isCollectionQuery()) {
            Collection collection = (Collection)source;
            Collection target = CollectionFactory.createCollection(collection.getClass(), collection.size());
            for (Object columns : collection) {
                target.add(this.type.isInstance(columns) ? columns : converter.convert(columns));
            }
            return (T)target;
        }
        return (T)converter.convert(source);
    }

    private static class ProjectingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final ReturnedType type;
        @NonNull
        private final ProjectionFactory factory;

        @Override
        public Object convert(Object source) {
            return this.factory.createProjection(this.type.getReturnedType(), this.getProjectionTarget(source));
        }

        private Object getProjectionTarget(Object source) {
            if (source != null && source.getClass().isArray()) {
                source = Arrays.asList((Object[])source);
            }
            if (source instanceof Collection) {
                return ProjectingConverter.toMap((Collection)source, this.type.getInputProperties());
            }
            return source;
        }

        private static Map<String, Object> toMap(Collection<?> values, List<String> names) {
            int i = 0;
            HashMap<String, Object> result = new HashMap<String, Object>(values.size());
            for (Object element : values) {
                result.put(names.get(i++), element);
            }
            return result;
        }

        @ConstructorProperties(value={"type", "factory"})
        public ProjectingConverter(@NonNull ReturnedType type, @NonNull ProjectionFactory factory) {
            if (type == null) {
                throw new IllegalArgumentException("type is null");
            }
            if (factory == null) {
                throw new IllegalArgumentException("factory is null");
            }
            this.type = type;
            this.factory = factory;
        }
    }

    private static enum NoOpConverter implements Converter<Object, Object>
    {
        INSTANCE;


        @Override
        public Object convert(Object source) {
            return source;
        }
    }

    private static class ChainingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final Class<?> targetType;
        @NonNull
        private final Converter<Object, Object> delegate;

        public ChainingConverter and(final Converter<Object, Object> converter) {
            Assert.notNull(converter, "Converter must not be null!");
            return new ChainingConverter(this.targetType, new Converter<Object, Object>(){

                @Override
                public Object convert(Object source) {
                    Object intermediate = ChainingConverter.this.convert(source);
                    return ChainingConverter.this.targetType.isInstance(intermediate) ? intermediate : converter.convert(intermediate);
                }
            });
        }

        @Override
        public Object convert(Object source) {
            return this.delegate.convert(source);
        }

        private ChainingConverter(@NonNull Class<?> targetType, @NonNull Converter<Object, Object> delegate) {
            if (targetType == null) {
                throw new IllegalArgumentException("targetType is null");
            }
            if (delegate == null) {
                throw new IllegalArgumentException("delegate is null");
            }
            this.targetType = targetType;
            this.delegate = delegate;
        }

        public static ChainingConverter of(@NonNull Class<?> targetType, @NonNull Converter<Object, Object> delegate) {
            return new ChainingConverter(targetType, delegate);
        }
    }
}

