/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.ReorderReceiptRuleSetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ReorderReceiptRuleSetRequestMarshaller
implements Marshaller<Request<ReorderReceiptRuleSetRequest>, ReorderReceiptRuleSetRequest> {
    @Override
    public Request<ReorderReceiptRuleSetRequest> marshall(ReorderReceiptRuleSetRequest reorderReceiptRuleSetRequest) {
        SdkInternalList ruleNamesList;
        if (reorderReceiptRuleSetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReorderReceiptRuleSetRequest> request = new DefaultRequest<ReorderReceiptRuleSetRequest>(reorderReceiptRuleSetRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "ReorderReceiptRuleSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (reorderReceiptRuleSetRequest.getRuleSetName() != null) {
            request.addParameter("RuleSetName", StringUtils.fromString(reorderReceiptRuleSetRequest.getRuleSetName()));
        }
        if (!(ruleNamesList = (SdkInternalList)reorderReceiptRuleSetRequest.getRuleNames()).isEmpty() || !ruleNamesList.isAutoConstruct()) {
            int ruleNamesListIndex = 1;
            for (String ruleNamesListValue : ruleNamesList) {
                if (ruleNamesListValue != null) {
                    request.addParameter("RuleNames.member." + ruleNamesListIndex, StringUtils.fromString(ruleNamesListValue));
                }
                ++ruleNamesListIndex;
            }
        }
        return request;
    }
}

