/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.duracloud.client.ContentStore;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.error.ContentStoreException;
import org.duracloud.snapshot.service.impl.ContentProperties;
import org.duracloud.snapshot.service.impl.StepExecutionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ItemWriter;

public class ContentPropertiesWriter
extends StepExecutionSupport
implements ItemWriter<ContentProperties>,
ItemWriteListener<ContentProperties> {
    private static Logger log = LoggerFactory.getLogger(ContentPropertiesWriter.class);
    private String destinationSpaceId;
    private ContentStore contentStore;
    private String storeId;
    private String storageProviderType;

    public ContentPropertiesWriter(ContentStore contentStore, String destinationSpaceId) {
        this.contentStore = contentStore;
        this.destinationSpaceId = destinationSpaceId;
        this.storeId = contentStore.getStoreId();
        this.storageProviderType = contentStore.getStorageProviderType();
        log.debug("constructed ContentPropertiesWriter for destination spaceId ({}), storeId ({}), storeType({})", destinationSpaceId, this.storeId, this.storageProviderType);
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        ExitStatus status = stepExecution.getExitStatus();
        List<String> errors = this.getErrors();
        if (errors.size() > 0) {
            status = status.and(ExitStatus.FAILED);
            for (String error : errors) {
                status = status.addExitDescription(error);
            }
            this.failExecution();
            this.resetContextState();
            log.error("content properties step finished with errors: step_execution_id={} job_execution_id={} store_id={} status=\"{}\"", stepExecution.getId(), stepExecution.getJobExecutionId(), this.contentStore.getStoreId(), status);
        } else {
            status = status.and(ExitStatus.COMPLETED);
            log.info("content properties step finished: step_execution_id={} job_execution_id={} store_id={}  exit_status={} ", stepExecution.getId(), stepExecution.getJobExecutionId(), this.contentStore.getStoreId(), status);
        }
        return status;
    }

    @Override
    public void afterWrite(List<? extends ContentProperties> items) {
        this.addToItemsRead(items.size());
    }

    @Override
    public void beforeWrite(List<? extends ContentProperties> items) {
        log.debug("firing beforeWrite {}", (Object)items);
    }

    @Override
    public void onWriteError(Exception exception, List<? extends ContentProperties> items) {
        log.error("firing onWriteError: currrently not handling: exception message=" + exception.getMessage(), exception);
        for (ContentProperties contentProperties : items) {
            this.addError("item failed: " + contentProperties + "; exception=" + exception.getMessage());
        }
    }

    @Override
    public void write(List<? extends ContentProperties> items) throws Exception {
        for (final ContentProperties contentProperties : items) {
            new Retrier().execute(new Retriable(){

                @Override
                public Object retry() throws Exception {
                    try {
                        ContentPropertiesWriter.this.contentStore.setContentProperties(ContentPropertiesWriter.this.destinationSpaceId, contentProperties.getContentId(), contentProperties.getProperties());
                        log.debug("wrote content properties ({}) to space ({}) on store ({}/{}):", contentProperties, ContentPropertiesWriter.this.destinationSpaceId, ContentPropertiesWriter.this.storeId, ContentPropertiesWriter.this.storageProviderType);
                        return null;
                    }
                    catch (ContentStoreException ex) {
                        log.warn("failed to update content properties ({}) to space({}); on store({}/{}). Trying with chunk manifest extension.", contentProperties, ContentPropertiesWriter.this.destinationSpaceId, ContentPropertiesWriter.this.storeId, ContentPropertiesWriter.this.storageProviderType);
                        String manifestId = contentProperties.getContentId() + ".dura-manifest";
                        HashMap<String, String> properties = new HashMap<String, String>(contentProperties.getProperties());
                        Map<String, String> chunkManifestProperties = ContentPropertiesWriter.this.contentStore.getContentProperties(ContentPropertiesWriter.this.destinationSpaceId, manifestId);
                        properties.putAll(chunkManifestProperties);
                        ContentPropertiesWriter.this.contentStore.setContentProperties(ContentPropertiesWriter.this.destinationSpaceId, manifestId, properties);
                        return null;
                    }
                }
            });
        }
    }
}

