/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.duracloud.chunk.util.ChunkUtil;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.model.ContentItem;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.retrieval.mgmt.OutputWriter;
import org.duracloud.retrieval.mgmt.RetrievalWorker;
import org.duracloud.retrieval.source.RetrievalSource;
import org.duracloud.snapshot.db.model.Snapshot;
import org.duracloud.snapshot.service.SnapshotManager;
import org.duracloud.snapshot.service.impl.ManifestFileHelper;
import org.duracloud.snapshot.service.impl.SpaceManifestDpnManifestVerifier;
import org.duracloud.snapshot.service.impl.StepExecutionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ItemWriter;

public class SpaceItemWriter
extends StepExecutionSupport
implements ItemWriter<ContentItem>,
ItemWriteListener<ContentItem> {
    private static final Logger log = LoggerFactory.getLogger(SpaceItemWriter.class);
    private RetrievalSource retrievalSource;
    private File contentDir;
    private OutputWriter outputWriter;
    private BufferedWriter propsWriter;
    private BufferedWriter md5Writer;
    private BufferedWriter sha256Writer;
    private ChecksumUtil sha256ChecksumUtil;
    private ContentItem snapshotPropsContentItem;
    private SnapshotManager snapshotManager;
    private Snapshot snapshot;
    private List<String> errors = new LinkedList<String>();
    private SpaceManifestDpnManifestVerifier spaceManifestDpnManifestVerifier;
    private ChunkUtil chunkUtil = new ChunkUtil();

    public SpaceItemWriter(Snapshot snapshot, RetrievalSource retrievalSource, File contentDir, OutputWriter outputWriter, BufferedWriter propsWriter, BufferedWriter md5Writer, BufferedWriter sha256Writer, SnapshotManager snapshotManager, SpaceManifestDpnManifestVerifier spaceManifestDpnManifestVerifier) {
        this.snapshot = snapshot;
        this.retrievalSource = retrievalSource;
        this.contentDir = contentDir;
        this.outputWriter = outputWriter;
        this.propsWriter = propsWriter;
        this.md5Writer = md5Writer;
        this.sha256Writer = sha256Writer;
        this.sha256ChecksumUtil = new ChecksumUtil(ChecksumUtil.Algorithm.SHA_256);
        this.snapshotManager = snapshotManager;
        this.spaceManifestDpnManifestVerifier = spaceManifestDpnManifestVerifier;
    }

    @Override
    public void write(List<? extends ContentItem> items) throws IOException {
        for (ContentItem contentItem : items) {
            String contentId = contentItem.getContentId();
            log.debug("writing: {}", (Object)contentId);
            if (!contentId.equals(".collection-snapshot.properties")) {
                File dataDir = this.getDataDir();
                this.retrieveFile(contentItem, dataDir);
                continue;
            }
            this.snapshotPropsContentItem = contentItem;
        }
    }

    private File getDataDir() {
        return new File(this.contentDir, "data");
    }

    protected void retrieveFile(ContentItem contentItem, File directory) throws IOException {
        this.retrieveFile(contentItem, directory, true, false);
    }

    protected void retrieveFile(ContentItem contentItem, File directory, boolean writeChecksums, boolean lastItem) throws IOException {
        RetrievalWorker retrievalWorker = new RetrievalWorker(contentItem, this.retrievalSource, directory, true, this.outputWriter, false, true);
        Map<String, String> props = retrievalWorker.retrieveFile();
        File localFile = retrievalWorker.getLocalFile();
        String md5Checksum = null;
        if (null != props) {
            md5Checksum = props.get("content-checksum");
        }
        log.info("Retrieved item {} from space {} with MD5 checksum {}", contentItem.getContentId(), contentItem.getSpaceId(), md5Checksum);
        String contentId = this.chunkUtil.preChunkedContentId(contentItem.getContentId());
        if (localFile.exists() && md5Checksum != null) {
            try {
                if (writeChecksums) {
                    this.writeMD5Checksum(contentId, md5Checksum);
                    this.writeSHA256Checksum(contentId, localFile);
                }
                this.writeToSnapshotManager(contentId, props);
                this.writeContentProperties(contentId, props, lastItem);
            }
            catch (IOException ioe) {
                log.error("Error writing snapshot details: " + ioe.getMessage());
                throw ioe;
            }
        } else {
            String baseError = String.format("Retrieved item {} from space {} could not be processed due to: ", contentItem.getContentId(), contentItem.getSpaceId());
            if (!localFile.exists()) {
                String error = baseError + "The local file at path " + localFile.getAbsolutePath() + " could not be found.";
                log.error(error);
                throw new IOException(error);
            }
            String error = baseError + "MD5 checksum for retrieved file was null";
            log.error(error);
            throw new IOException(error);
        }
    }

    private void writeToSnapshotManager(final String contentId, final Map<String, String> props) throws IOException {
        try {
            new Retrier().execute(new Retriable(){

                @Override
                public Object retry() throws Exception {
                    SpaceItemWriter.this.snapshotManager.addContentItem(SpaceItemWriter.this.snapshot, contentId, props);
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error("failed to add snapshot content item: " + contentId + " to snapshot " + this.snapshot + ": " + e.getMessage(), e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMD5Checksum(String contentId, String md5Checksum) throws IOException {
        BufferedWriter bufferedWriter = this.md5Writer;
        synchronized (bufferedWriter) {
            ManifestFileHelper.writeManifestEntry(this.md5Writer, contentId, md5Checksum);
        }
    }

    protected synchronized void writeSHA256Checksum(String contentId, File localFile) throws IOException {
        String sha256Checksum = this.sha256ChecksumUtil.generateChecksum(localFile);
        ManifestFileHelper.writeManifestEntry(this.sha256Writer, contentId, sha256Checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeContentProperties(String contentId, Map<String, String> props, boolean lastItem) throws IOException {
        Set<String> propKeys = props.keySet();
        StringBuffer sb = new StringBuffer(100);
        sb.append("{\n  \"" + contentId + "\": {\n");
        for (String propKey : propKeys) {
            sb.append("    \"" + propKey + "\": \"" + props.get(propKey) + "\",\n");
        }
        sb.deleteCharAt(sb.length() - 2);
        sb.append("  }\n}");
        if (!lastItem) {
            sb.append(",");
        }
        sb.append("\n");
        BufferedWriter bufferedWriter = this.propsWriter;
        synchronized (bufferedWriter) {
            this.propsWriter.write(sb.toString());
        }
    }

    protected void retrieveSnapshotProperties() {
        if (this.snapshotPropsContentItem != null) {
            try {
                this.retrieveFile(this.snapshotPropsContentItem, this.contentDir, false, true);
                log.info("snapshot properties retrieved");
            }
            catch (IOException ioe) {
                log.error("Error retrieving the snapshot properties file: ", ioe);
            }
        } else {
            String message = "No snapshot properties file found. (.collection-snapshot.properties)";
            log.error(message);
            this.errors.add(message);
        }
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        ExitStatus status = super.afterStep(stepExecution);
        log.info("Step complete with status: {}", (Object)stepExecution.getExitStatus());
        this.close("md5 writer", this.md5Writer);
        this.close("sh256 writer", this.sha256Writer);
        this.close("output writer", this.outputWriter);
        this.retrieveSnapshotProperties();
        this.closePropsWriter();
        if (this.errors.size() == 0) {
            log.info("no errors - proceeding with space manifest -dpn manifest verification...");
            this.errors.addAll(this.verifySpace(this.spaceManifestDpnManifestVerifier));
        }
        if (this.errors.size() > 0) {
            stepExecution.upgradeStatus(BatchStatus.FAILED);
            status = status.and(ExitStatus.FAILED);
            for (String error : this.errors) {
                status = status.addExitDescription(error);
            }
            log.error("space item writer failed due to the following error(s): " + status.getExitDescription());
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePropsWriter() {
        try {
            BufferedWriter bufferedWriter = this.propsWriter;
            synchronized (bufferedWriter) {
                this.propsWriter.write("]\n");
            }
            log.info("closed props writer");
        }
        catch (IOException ioe) {
            String message = "Error writing end of content property manifest: " + ioe.getMessage();
            this.errors.add(message);
            log.error(message, ioe);
        }
        finally {
            IOUtils.closeQuietly(this.propsWriter);
        }
    }

    private void close(String writerName, Object writer) {
        try {
            if (writer instanceof Closeable) {
                ((Closeable)writer).close();
            } else if (writer instanceof OutputWriter) {
                ((OutputWriter)writer).close();
            } else {
                throw new DuraCloudRuntimeException(writerName + " is not a supported parameter type for this method.");
            }
            log.info("closed {}", (Object)writerName);
        }
        catch (IOException ioe) {
            String message = "Error closing " + writerName + " BufferedWriter: " + ioe.getMessage();
            this.errors.add(message);
            log.error(message, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeStep(StepExecution stepExecution) {
        super.beforeStep(stepExecution);
        log.info("starting step {}");
        try {
            this.errors.clear();
            BufferedWriter bufferedWriter = this.propsWriter;
            synchronized (bufferedWriter) {
                this.propsWriter.write("[\n");
            }
        }
        catch (IOException ioe) {
            log.error("Error writing start of content property manifest: ", ioe);
        }
    }

    @Override
    public void onWriteError(Exception e, List<? extends ContentItem> items) {
        StringBuilder sb = new StringBuilder();
        for (ContentItem contentItem : items) {
            sb.append(contentItem.getContentId() + ", ");
        }
        String message = "Error writing item(s): " + e.getMessage() + ": items=" + sb.toString();
        this.errors.add(message);
        log.error(message, e);
    }

    @Override
    public void beforeWrite(List<? extends ContentItem> items) {
    }

    @Override
    public void afterWrite(List<? extends ContentItem> items) {
    }
}

