/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.DataSource;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@Deprecated
public class IbatisPagingItemReader<T>
extends AbstractPagingItemReader<T> {
    private SqlMapClient sqlMapClient;
    private String queryId;
    private Map<String, Object> parameterValues;
    private DataSource dataSource;

    public IbatisPagingItemReader() {
        this.setName(ClassUtils.getShortName(IbatisPagingItemReader.class));
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull(this.sqlMapClient);
        Assert.notNull(this.queryId);
    }

    @Override
    protected void doReadPage() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.parameterValues != null) {
            parameters.putAll(this.parameterValues);
        }
        parameters.put("_page", this.getPage());
        parameters.put("_pagesize", this.getPageSize());
        parameters.put("_skiprows", this.getPage() * this.getPageSize());
        if (this.results == null) {
            this.results = new CopyOnWriteArrayList();
        } else {
            this.results.clear();
        }
        this.results.addAll(this.execute(parameters));
    }

    /*
     * Loose catch block
     */
    private List<T> execute(Map<String, Object> parameters) {
        SqlMapSession session = this.sqlMapClient.openSession();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Opened SqlMapSession [" + session + "] for iBATIS operation");
        }
        Connection ibatisCon = null;
        try {
            Connection springCon = null;
            boolean transactionAware = this.dataSource instanceof TransactionAwareDataSourceProxy;
            try {
                ibatisCon = session.getCurrentConnection();
                if (ibatisCon == null) {
                    springCon = transactionAware ? this.dataSource.getConnection() : DataSourceUtils.doGetConnection(this.dataSource);
                    session.setUserConnection(springCon);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Obtained JDBC Connection [" + springCon + "] for iBATIS operation");
                    }
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Reusing JDBC Connection [" + ibatisCon + "] for iBATIS operation");
                }
            }
            catch (SQLException ex) {
                throw new CannotGetJdbcConnectionException("Could not get JDBC Connection", ex);
            }
            try {
                List ex = session.queryForList(this.queryId, parameters);
                return ex;
            }
            catch (SQLException ex) {
                AbstractFallbackSQLExceptionTranslator sqlStateSQLExceptionTranslator = this.dataSource != null ? new SQLStateSQLExceptionTranslator() : new SQLErrorCodeSQLExceptionTranslator(this.dataSource);
                throw sqlStateSQLExceptionTranslator.translate("SqlMapClient operation", null, ex);
            }
            finally {
                try {
                    if (springCon != null) {
                        if (transactionAware) {
                            springCon.close();
                        } else {
                            DataSourceUtils.doReleaseConnection(springCon, this.dataSource);
                        }
                    }
                }
                catch (Throwable ex) {
                    this.logger.debug("Could not close JDBC Connection", ex);
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (ibatisCon == null) {
                session.close();
            }
        }
    }

    @Override
    protected void doJumpToPage(int itemIndex) {
    }
}

