/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.mail;

import java.util.List;
import java.util.Map;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.mail.DefaultMailErrorHandler;
import org.springframework.batch.item.mail.MailErrorHandler;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.mail.MailException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.MailSendException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.util.Assert;

public class SimpleMailMessageItemWriter
implements ItemWriter<SimpleMailMessage>,
InitializingBean {
    private MailSender mailSender;
    private MailErrorHandler mailErrorHandler = new DefaultMailErrorHandler();

    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setMailErrorHandler(MailErrorHandler mailErrorHandler) {
        this.mailErrorHandler = mailErrorHandler;
    }

    @Override
    public void afterPropertiesSet() throws IllegalStateException {
        Assert.state(this.mailSender != null, "A MailSender must be provided.");
    }

    @Override
    public void write(List<? extends SimpleMailMessage> items) throws MailException {
        try {
            this.mailSender.send(items.toArray(new SimpleMailMessage[items.size()]));
        }
        catch (MailSendException e) {
            Map failedMessages = e.getFailedMessages();
            for (Map.Entry entry : failedMessages.entrySet()) {
                this.mailErrorHandler.handle((MailMessage)((SimpleMailMessage)entry.getKey()), (Exception)entry.getValue());
            }
        }
    }
}

