/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.batch.item.ItemWriter;
import org.springframework.classify.Classifier;
import org.springframework.classify.ClassifierSupport;

public class ClassifierCompositeItemWriter<T>
implements ItemWriter<T> {
    private Classifier<T, ItemWriter<? super T>> classifier = new ClassifierSupport<T, Object>(null);

    public void setClassifier(Classifier<T, ItemWriter<? super T>> classifier) {
        this.classifier = classifier;
    }

    @Override
    public void write(List<? extends T> items) throws Exception {
        LinkedHashMap map = new LinkedHashMap();
        for (T item : items) {
            ItemWriter<? super T> key = this.classifier.classify(item);
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            ((List)map.get(key)).add(item);
        }
        for (ItemWriter writer : map.keySet()) {
            writer.write((List)map.get(writer));
        }
    }
}

