/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.convert.QueryByExamplePredicateBuilder;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.query.Jpa21Utils;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Repository
@Transactional(readOnly=true)
public class SimpleJpaRepository<T, ID extends Serializable>
implements JpaRepository<T, ID>,
JpaSpecificationExecutor<T> {
    private static final String ID_MUST_NOT_BE_NULL = "The given id must not be null!";
    private final JpaEntityInformation<T, ?> entityInformation;
    private final EntityManager em;
    private final PersistenceProvider provider;
    private CrudMethodMetadata metadata;

    public SimpleJpaRepository(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        Assert.notNull(entityInformation);
        Assert.notNull(entityManager);
        this.entityInformation = entityInformation;
        this.em = entityManager;
        this.provider = PersistenceProvider.fromEntityManager(entityManager);
    }

    public SimpleJpaRepository(Class<T> domainClass, EntityManager em) {
        this(JpaEntityInformationSupport.getEntityInformation(domainClass, em), em);
    }

    public void setRepositoryMethodMetadata(CrudMethodMetadata crudMethodMetadata) {
        this.metadata = crudMethodMetadata;
    }

    protected CrudMethodMetadata getRepositoryMethodMetadata() {
        return this.metadata;
    }

    protected Class<T> getDomainClass() {
        return this.entityInformation.getJavaType();
    }

    private String getDeleteAllQueryString() {
        return QueryUtils.getQueryString("delete from %s x", this.entityInformation.getEntityName());
    }

    private String getCountQueryString() {
        String countQuery = String.format("select count(%s) from %s x", this.provider.getCountQueryPlaceholder(), "%s");
        return QueryUtils.getQueryString(countQuery, this.entityInformation.getEntityName());
    }

    @Override
    @Transactional
    public void delete(ID id) {
        Assert.notNull(id, ID_MUST_NOT_BE_NULL);
        T entity = this.findOne(id);
        if (entity == null) {
            throw new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", this.entityInformation.getJavaType(), id), 1);
        }
        this.delete(entity);
    }

    @Override
    @Transactional
    public void delete(T entity) {
        Assert.notNull(entity, "The entity must not be null!");
        this.em.remove(this.em.contains(entity) ? entity : this.em.merge(entity));
    }

    @Override
    @Transactional
    public void delete(Iterable<? extends T> entities) {
        Assert.notNull(entities, "The given Iterable of entities not be null!");
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    @Override
    @Transactional
    public void deleteInBatch(Iterable<T> entities) {
        Assert.notNull(entities, "The given Iterable of entities not be null!");
        if (!entities.iterator().hasNext()) {
            return;
        }
        QueryUtils.applyAndBind(QueryUtils.getQueryString("delete from %s x", this.entityInformation.getEntityName()), entities, this.em).executeUpdate();
    }

    @Override
    @Transactional
    public void deleteAll() {
        for (Object element : this.findAll()) {
            this.delete((T)element);
        }
    }

    @Override
    @Transactional
    public void deleteAllInBatch() {
        this.em.createQuery(this.getDeleteAllQueryString()).executeUpdate();
    }

    @Override
    public T findOne(ID id) {
        Assert.notNull(id, ID_MUST_NOT_BE_NULL);
        Class<T> domainType = this.getDomainClass();
        if (this.metadata == null) {
            return this.em.find(domainType, id);
        }
        LockModeType type = this.metadata.getLockModeType();
        Map<String, Object> hints = this.getQueryHints();
        return type == null ? this.em.find(domainType, id, hints) : this.em.find(domainType, id, type, hints);
    }

    protected Map<String, Object> getQueryHints() {
        if (this.metadata.getEntityGraph() == null) {
            return this.metadata.getQueryHints();
        }
        HashMap<String, Object> hints = new HashMap<String, Object>();
        hints.putAll(this.metadata.getQueryHints());
        hints.putAll(Jpa21Utils.tryGetFetchGraphHints(this.em, this.getEntityGraph(), this.getDomainClass()));
        return hints;
    }

    private JpaEntityGraph getEntityGraph() {
        String fallbackName = this.entityInformation.getEntityName() + "." + this.metadata.getMethod().getName();
        return new JpaEntityGraph(this.metadata.getEntityGraph(), fallbackName);
    }

    @Override
    public T getOne(ID id) {
        Assert.notNull(id, ID_MUST_NOT_BE_NULL);
        return this.em.getReference(this.getDomainClass(), id);
    }

    @Override
    public boolean exists(ID id) {
        Assert.notNull(id, ID_MUST_NOT_BE_NULL);
        if (this.entityInformation.getIdAttribute() == null) {
            return this.findOne(id) != null;
        }
        String placeholder = this.provider.getCountQueryPlaceholder();
        String entityName = this.entityInformation.getEntityName();
        Iterable<String> idAttributeNames = this.entityInformation.getIdAttributeNames();
        String existsQuery = QueryUtils.getExistsQueryString(entityName, placeholder, idAttributeNames);
        TypedQuery<Long> query = this.em.createQuery(existsQuery, Long.class);
        if (!this.entityInformation.hasCompositeId()) {
            query.setParameter(idAttributeNames.iterator().next(), id);
            return query.getSingleResult() == 1L;
        }
        for (String idAttributeName : idAttributeNames) {
            boolean complexIdParameterValueDiscovered;
            Object idAttributeValue = this.entityInformation.getCompositeIdAttributeValue((Serializable)id, idAttributeName);
            boolean bl = complexIdParameterValueDiscovered = idAttributeValue != null && !query.getParameter(idAttributeName).getParameterType().isAssignableFrom(idAttributeValue.getClass());
            if (complexIdParameterValueDiscovered) {
                return this.findOne(id) != null;
            }
            query.setParameter(idAttributeName, idAttributeValue);
        }
        return query.getSingleResult() == 1L;
    }

    @Override
    public List<T> findAll() {
        return this.getQuery(null, (Sort)null).getResultList();
    }

    @Override
    public List<T> findAll(Iterable<ID> ids) {
        if (ids == null || !ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        if (this.entityInformation.hasCompositeId()) {
            ArrayList<T> results = new ArrayList<T>();
            for (Serializable id : ids) {
                results.add(this.findOne(id));
            }
            return results;
        }
        ByIdsSpecification<T> specification = new ByIdsSpecification<T>(this.entityInformation);
        TypedQuery<Iterable<ID>> query = this.getQuery(specification, (Sort)null);
        return query.setParameter(specification.parameter, ids).getResultList();
    }

    @Override
    public List<T> findAll(Sort sort) {
        return this.getQuery(null, sort).getResultList();
    }

    @Override
    public Page<T> findAll(Pageable pageable) {
        if (null == pageable) {
            return new PageImpl(this.findAll());
        }
        return this.findAll((Specification)null, pageable);
    }

    @Override
    public T findOne(Specification<T> spec) {
        try {
            return this.getQuery(spec, (Sort)null).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<T> findAll(Specification<T> spec) {
        return this.getQuery(spec, (Sort)null).getResultList();
    }

    @Override
    public Page<T> findAll(Specification<T> spec, Pageable pageable) {
        TypedQuery<T> query = this.getQuery(spec, pageable);
        return pageable == null ? new PageImpl<T>(query.getResultList()) : this.readPage(query, pageable, spec);
    }

    @Override
    public List<T> findAll(Specification<T> spec, Sort sort) {
        return this.getQuery(spec, sort).getResultList();
    }

    @Override
    public <S extends T> S findOne(Example<S> example) {
        try {
            return this.getQuery(new ExampleSpecification<S>(example), example.getProbeType(), (Sort)null).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public <S extends T> long count(Example<S> example) {
        return SimpleJpaRepository.executeCountQuery(this.getCountQuery(new ExampleSpecification<S>(example), example.getProbeType()));
    }

    @Override
    public <S extends T> boolean exists(Example<S> example) {
        return !this.getQuery(new ExampleSpecification<S>(example), example.getProbeType(), (Sort)null).getResultList().isEmpty();
    }

    @Override
    public <S extends T> List<S> findAll(Example<S> example) {
        return this.getQuery(new ExampleSpecification<S>(example), example.getProbeType(), (Sort)null).getResultList();
    }

    @Override
    public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
        return this.getQuery(new ExampleSpecification<S>(example), example.getProbeType(), sort).getResultList();
    }

    @Override
    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        ExampleSpecification<S> spec = new ExampleSpecification<S>(example);
        Class<S> probeType = example.getProbeType();
        TypedQuery<S> query = this.getQuery(new ExampleSpecification<S>(example), probeType, pageable);
        return pageable == null ? new PageImpl<S>(query.getResultList()) : this.readPage(query, probeType, pageable, spec);
    }

    @Override
    public long count() {
        return this.em.createQuery(this.getCountQueryString(), Long.class).getSingleResult();
    }

    @Override
    public long count(Specification<T> spec) {
        return SimpleJpaRepository.executeCountQuery(this.getCountQuery(spec));
    }

    @Override
    @Transactional
    public <S extends T> S save(S entity) {
        if (this.entityInformation.isNew(entity)) {
            this.em.persist(entity);
            return entity;
        }
        return this.em.merge(entity);
    }

    @Override
    @Transactional
    public <S extends T> S saveAndFlush(S entity) {
        S result = this.save(entity);
        this.flush();
        return result;
    }

    @Override
    @Transactional
    public <S extends T> List<S> save(Iterable<S> entities) {
        ArrayList<S> result = new ArrayList<S>();
        if (entities == null) {
            return result;
        }
        for (S entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    @Override
    @Transactional
    public void flush() {
        this.em.flush();
    }

    protected Page<T> readPage(TypedQuery<T> query, Pageable pageable, Specification<T> spec) {
        return this.readPage(query, this.getDomainClass(), pageable, spec);
    }

    protected <S extends T> Page<S> readPage(TypedQuery<S> query, Class<S> domainClass, Pageable pageable, Specification<S> spec) {
        query.setFirstResult(pageable.getOffset());
        query.setMaxResults(pageable.getPageSize());
        Long total = SimpleJpaRepository.executeCountQuery(this.getCountQuery(spec, domainClass));
        List<Object> content = total > (long)pageable.getOffset() ? query.getResultList() : Collections.emptyList();
        return new PageImpl(content, pageable, total);
    }

    protected TypedQuery<T> getQuery(Specification<T> spec, Pageable pageable) {
        Sort sort = pageable == null ? null : pageable.getSort();
        return this.getQuery(spec, this.getDomainClass(), sort);
    }

    protected <S extends T> TypedQuery<S> getQuery(Specification<S> spec, Class<S> domainClass, Pageable pageable) {
        Sort sort = pageable == null ? null : pageable.getSort();
        return this.getQuery(spec, domainClass, sort);
    }

    protected TypedQuery<T> getQuery(Specification<T> spec, Sort sort) {
        return this.getQuery(spec, this.getDomainClass(), sort);
    }

    protected <S extends T> TypedQuery<S> getQuery(Specification<S> spec, Class<S> domainClass, Sort sort) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery<S> query = builder.createQuery(domainClass);
        Root<S> root = this.applySpecificationToCriteria(spec, domainClass, query);
        query.select(root);
        if (sort != null) {
            query.orderBy(QueryUtils.toOrders(sort, root, builder));
        }
        return this.applyRepositoryMethodMetadata(this.em.createQuery(query));
    }

    protected TypedQuery<Long> getCountQuery(Specification<T> spec) {
        return this.getCountQuery(spec, this.getDomainClass());
    }

    protected <S extends T> TypedQuery<Long> getCountQuery(Specification<S> spec, Class<S> domainClass) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery<Long> query = builder.createQuery(Long.class);
        Root<S> root = this.applySpecificationToCriteria(spec, domainClass, query);
        if (query.isDistinct()) {
            query.select(builder.countDistinct(root));
        } else {
            query.select(builder.count(root));
        }
        return this.em.createQuery(query);
    }

    private <S> Root<T> applySpecificationToCriteria(Specification<T> spec, CriteriaQuery<S> query) {
        return this.applySpecificationToCriteria(spec, this.getDomainClass(), query);
    }

    private <S, U extends T> Root<U> applySpecificationToCriteria(Specification<U> spec, Class<U> domainClass, CriteriaQuery<S> query) {
        Assert.notNull(query);
        Assert.notNull(domainClass);
        Root<U> root = query.from(domainClass);
        if (spec == null) {
            return root;
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        Predicate predicate = spec.toPredicate(root, query, builder);
        if (predicate != null) {
            query.where((Expression<Boolean>)predicate);
        }
        return root;
    }

    private <S> TypedQuery<S> applyRepositoryMethodMetadata(TypedQuery<S> query) {
        if (this.metadata == null) {
            return query;
        }
        LockModeType type = this.metadata.getLockModeType();
        TypedQuery<S> toReturn = type == null ? query : query.setLockMode(type);
        this.applyQueryHints(toReturn);
        return toReturn;
    }

    private void applyQueryHints(Query query) {
        for (Map.Entry<String, Object> hint : this.getQueryHints().entrySet()) {
            query.setHint(hint.getKey(), hint.getValue());
        }
    }

    private static Long executeCountQuery(TypedQuery<Long> query) {
        Assert.notNull(query);
        List<Long> totals = query.getResultList();
        Long total = 0L;
        for (Long element : totals) {
            total = total + (element == null ? 0L : element);
        }
        return total;
    }

    private static class ExampleSpecification<T>
    implements Specification<T> {
        private final Example<T> example;

        public ExampleSpecification(Example<T> example) {
            Assert.notNull(example, "Example must not be null!");
            this.example = example;
        }

        @Override
        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            return QueryByExamplePredicateBuilder.getPredicate(root, cb, this.example);
        }
    }

    private static final class ByIdsSpecification<T>
    implements Specification<T> {
        private final JpaEntityInformation<T, ?> entityInformation;
        ParameterExpression<Iterable> parameter;

        public ByIdsSpecification(JpaEntityInformation<T, ?> entityInformation) {
            this.entityInformation = entityInformation;
        }

        @Override
        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            Path<?> path = root.get(this.entityInformation.getIdAttribute());
            this.parameter = cb.parameter(Iterable.class);
            return path.in(new Expression[]{this.parameter});
        }
    }
}

