/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BridgeConfiguration {
    public static final String DURACLOUD_BRIDGE_ROOT_SYSTEM_PROPERTY = "duracloud.bridge.root.dir";
    public static final String DURACLOUD_BRIDGE_THREADS_PER_JOB = "duracloud.bridge.threads-per-job";
    private String[] duracloudEmailAddresses;
    private String duracloudUsername;
    private String duracloudPassword;
    private static Logger log = LoggerFactory.getLogger(BridgeConfiguration.class);

    public String getDuracloudUsername() {
        return this.duracloudUsername;
    }

    public void setDuracloudUsername(String duracloudUsername) {
        this.duracloudUsername = duracloudUsername;
    }

    public String getDuracloudPassword() {
        return this.duracloudPassword;
    }

    public void setDuracloudPassword(String duracloudPassword) {
        this.duracloudPassword = duracloudPassword;
    }

    public String[] getDuracloudEmailAddresses() {
        return this.duracloudEmailAddresses;
    }

    public void setDuracloudEmailAddresses(String[] duracloudAdminEmails) {
        this.duracloudEmailAddresses = duracloudAdminEmails;
    }

    public static File getBridgeRootDir() {
        String rootDir = System.getProperty(DURACLOUD_BRIDGE_ROOT_SYSTEM_PROPERTY);
        if (rootDir == null) {
            throw new RuntimeException("Unable to locate  bridge root directory because the duracloud.bridge.root.dir system property was not set.  Please specify a java command line parameter (e.g. -Dduracloud.bridge.root.dir=/path/to/root/dir)");
        }
        File file = BridgeConfiguration.createDirectoryIfNotExists(rootDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private static File createDirectoryIfNotExists(String path) {
        File wdir = new File(path);
        if (!wdir.exists() && !wdir.mkdirs()) {
            throw new RuntimeException("failed to initialize " + path + ": directory could not be created.");
        }
        if (!wdir.canWrite()) {
            throw new RuntimeException(wdir.getAbsolutePath() + " must be writable.");
        }
        return wdir;
    }

    public static File getContentRootDir() {
        return BridgeConfiguration.createDirectoryIfNotExists(new File(BridgeConfiguration.getBridgeRootDir(), "content").getAbsolutePath());
    }

    public static File getBridgeWorkDir() {
        return BridgeConfiguration.createDirectoryIfNotExists(new File(BridgeConfiguration.getBridgeRootDir(), "work").getAbsolutePath());
    }

    public static int getBridgeThreadsPerJob() {
        int availableProcessors;
        String threadsPerJobConfig = System.getProperty(DURACLOUD_BRIDGE_THREADS_PER_JOB);
        if (null != threadsPerJobConfig) {
            try {
                return Integer.parseInt(threadsPerJobConfig);
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse system property duracloud.bridge.threads-per-job with value " + threadsPerJobConfig + " into an int. Proceeding with default threads setting.");
            }
        }
        if ((availableProcessors = Runtime.getRuntime().availableProcessors()) > 1) {
            return availableProcessors - 1;
        }
        return 1;
    }
}

