/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import org.springframework.batch.core.jsr.configuration.support.BatchArtifactType;
import org.springframework.batch.core.jsr.configuration.xml.PropertyParser;
import org.springframework.batch.core.jsr.configuration.xml.StepFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class BatchletParser
extends AbstractSingleBeanDefinitionParser {
    private static final String REF = "ref";

    public void parseBatchlet(Element batchletElement, AbstractBeanDefinition bd, ParserContext parserContext, String stepName) {
        bd.setBeanClass(StepFactoryBean.class);
        bd.setAttribute("isNamespaceStep", false);
        String taskletRef = batchletElement.getAttribute(REF);
        if (StringUtils.hasText(taskletRef)) {
            bd.getPropertyValues().addPropertyValue("stepTasklet", new RuntimeBeanReference(taskletRef));
        }
        bd.setRole(1);
        bd.setSource(parserContext.extractSource(batchletElement));
        new PropertyParser(taskletRef, parserContext, BatchArtifactType.STEP_ARTIFACT, stepName).parseProperties(batchletElement);
    }
}

