/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.listener.CompositeStepExecutionListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractStep
implements Step,
InitializingBean,
BeanNameAware {
    private static final Log logger = LogFactory.getLog(AbstractStep.class);
    private String name;
    private int startLimit = Integer.MAX_VALUE;
    private boolean allowStartIfComplete = false;
    private CompositeStepExecutionListener stepExecutionListener = new CompositeStepExecutionListener();
    private JobRepository jobRepository;

    public AbstractStep() {
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.name != null, "A Step must have a name");
        Assert.state(this.jobRepository != null, "JobRepository is mandatory");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setBeanName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    @Override
    public int getStartLimit() {
        return this.startLimit;
    }

    public void setStartLimit(int startLimit) {
        this.startLimit = startLimit == 0 ? Integer.MAX_VALUE : startLimit;
    }

    @Override
    public boolean isAllowStartIfComplete() {
        return this.allowStartIfComplete;
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public AbstractStep(String name) {
        this.name = name;
    }

    protected abstract void doExecute(StepExecution var1) throws Exception;

    protected void open(ExecutionContext ctx) throws Exception {
    }

    protected void close(ExecutionContext ctx) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final void execute(StepExecution stepExecution) throws JobInterruptedException, UnexpectedJobExecutionException {
        block39: {
            ExitStatus exitStatus;
            block37: {
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing: id=" + stepExecution.getId());
                }
                stepExecution.setStartTime(new Date());
                stepExecution.setStatus(BatchStatus.STARTED);
                this.getJobRepository().update(stepExecution);
                exitStatus = ExitStatus.EXECUTING;
                this.doExecutionRegistration(stepExecution);
                this.getCompositeListener().beforeStep(stepExecution);
                this.open(stepExecution.getExecutionContext());
                try {
                    this.doExecute(stepExecution);
                }
                catch (RepeatException e) {
                    throw e.getCause();
                }
                exitStatus = ExitStatus.COMPLETED.and(stepExecution.getExitStatus());
                if (stepExecution.isTerminateOnly()) {
                    throw new JobInterruptedException("JobExecution interrupted.");
                }
                stepExecution.upgradeStatus(BatchStatus.COMPLETED);
                if (!logger.isDebugEnabled()) break block37;
                logger.debug("Step execution success: id=" + stepExecution.getId());
            }
            try {
                exitStatus = exitStatus.and(stepExecution.getExitStatus());
                stepExecution.setExitStatus(exitStatus);
                exitStatus = exitStatus.and(this.getCompositeListener().afterStep(stepExecution));
            }
            catch (Exception e) {
                logger.error(String.format("Exception in afterStep callback in step %s in job %s", this.name, stepExecution.getJobExecution().getJobInstance().getJobName()), e);
            }
            try {
                this.getJobRepository().updateExecutionContext(stepExecution);
            }
            catch (Exception e) {
                stepExecution.setStatus(BatchStatus.UNKNOWN);
                exitStatus = exitStatus.and(ExitStatus.UNKNOWN);
                stepExecution.addFailureException(e);
                logger.error(String.format("Encountered an error saving batch meta data for step %s in job %s. This job is now in an unknown state and should not be restarted.", this.name, stepExecution.getJobExecution().getJobInstance().getJobName()), e);
            }
            stepExecution.setEndTime(new Date());
            stepExecution.setExitStatus(exitStatus);
            try {
                this.getJobRepository().update(stepExecution);
            }
            catch (Exception e) {
                stepExecution.setStatus(BatchStatus.UNKNOWN);
                stepExecution.setExitStatus(exitStatus.and(ExitStatus.UNKNOWN));
                stepExecution.addFailureException(e);
                logger.error(String.format("Encountered an error saving batch meta data for step %s in job %s. This job is now in an unknown state and should not be restarted.", this.name, stepExecution.getJobExecution().getJobInstance().getJobName()), e);
            }
            try {
                this.close(stepExecution.getExecutionContext());
            }
            catch (Exception e) {
                logger.error(String.format("Exception while closing step execution resources in step %s in job %s", this.name, stepExecution.getJobExecution().getJobInstance().getJobName()), e);
                stepExecution.addFailureException(e);
            }
            this.doExecutionRelease();
            if (logger.isDebugEnabled()) {
                logger.debug("Step execution complete: " + stepExecution.getSummary());
            }
            break block39;
            catch (Throwable e) {
                block38: {
                    try {
                        stepExecution.upgradeStatus(AbstractStep.determineBatchStatus(e));
                        exitStatus = exitStatus.and(this.getDefaultExitStatusForFailure(e));
                        stepExecution.addFailureException(e);
                        if (stepExecution.getStatus() == BatchStatus.STOPPED) {
                            logger.info(String.format("Encountered interruption executing step %s in job %s : %s", this.name, stepExecution.getJobExecution().getJobInstance().getJobName(), e.getMessage()));
                            if (logger.isDebugEnabled()) {
                                logger.debug("Full exception", e);
                            }
                            break block38;
                        }
                        logger.error(String.format("Encountered an error executing step %s in job %s", this.name, stepExecution.getJobExecution().getJobInstance().getJobName()), e);
                    }
                    catch (Throwable throwable) {
                        try {
                            exitStatus = exitStatus.and(stepExecution.getExitStatus());
                            stepExecution.setExitStatus(exitStatus);
                            exitStatus = exitStatus.and(this.getCompositeListener().afterStep(stepExecution));
                        }
                        catch (Exception e2) {
                            logger.error(String.format("Exception in afterStep callback in step %s in job %s", this.name, stepExecution.getJobExecution().getJobInstance().getJobName()), e2);
                        }
                        try {
                            this.getJobRepository().updateExecutionContext(stepExecution);
                        }
                        catch (Exception e3) {
                            stepExecution.setStatus(BatchStatus.UNKNOWN);
                            exitStatus = exitStatus.and(ExitStatus.UNKNOWN);
                            stepExecution.addFailureException(e3);
                            logger.error(String.format("Encountered an error saving batch meta data for step %s in job %s. This job is now in an unknown state and should not be restarted.", this.name, stepExecution.getJobExecution().getJobInstance().getJobName()), e3);
                        }
                        stepExecution.setEndTime(new Date());
                        stepExecution.setExitStatus(exitStatus);
                        try {
                            this.getJobRepository().update(stepExecution);
                        }
                        catch (Exception e4) {
                            stepExecution.setStatus(BatchStatus.UNKNOWN);
                            stepExecution.setExitStatus(exitStatus.and(ExitStatus.UNKNOWN));
                            stepExecution.addFailureException(e4);
                            logger.error(String.format("Encountered an error saving batch meta data for step %s in job %s. This job is now in an unknown state and should not be restarted.", this.name, stepExecution.getJobExecution().getJobInstance().getJobName()), e4);
                        }
                        try {
                            this.close(stepExecution.getExecutionContext());
                        }
                        catch (Exception e5) {
                            logger.error(String.format("Exception while closing step execution resources in step %s in job %s", this.name, stepExecution.getJobExecution().getJobInstance().getJobName()), e5);
                            stepExecution.addFailureException(e5);
                        }
                        this.doExecutionRelease();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Step execution complete: " + stepExecution.getSummary());
                        }
                        throw throwable;
                    }
                }
                try {
                    exitStatus = exitStatus.and(stepExecution.getExitStatus());
                    stepExecution.setExitStatus(exitStatus);
                    exitStatus = exitStatus.and(this.getCompositeListener().afterStep(stepExecution));
                }
                catch (Exception e6) {
                    logger.error(String.format("Exception in afterStep callback in step %s in job %s", this.name, stepExecution.getJobExecution().getJobInstance().getJobName()), e6);
                }
                try {
                    this.getJobRepository().updateExecutionContext(stepExecution);
                }
                catch (Exception e7) {
                    stepExecution.setStatus(BatchStatus.UNKNOWN);
                    exitStatus = exitStatus.and(ExitStatus.UNKNOWN);
                    stepExecution.addFailureException(e7);
                    logger.error(String.format("Encountered an error saving batch meta data for step %s in job %s. This job is now in an unknown state and should not be restarted.", this.name, stepExecution.getJobExecution().getJobInstance().getJobName()), e7);
                }
                stepExecution.setEndTime(new Date());
                stepExecution.setExitStatus(exitStatus);
                try {
                    this.getJobRepository().update(stepExecution);
                }
                catch (Exception e8) {
                    stepExecution.setStatus(BatchStatus.UNKNOWN);
                    stepExecution.setExitStatus(exitStatus.and(ExitStatus.UNKNOWN));
                    stepExecution.addFailureException(e8);
                    logger.error(String.format("Encountered an error saving batch meta data for step %s in job %s. This job is now in an unknown state and should not be restarted.", this.name, stepExecution.getJobExecution().getJobInstance().getJobName()), e8);
                }
                try {
                    this.close(stepExecution.getExecutionContext());
                }
                catch (Exception e9) {
                    logger.error(String.format("Exception while closing step execution resources in step %s in job %s", this.name, stepExecution.getJobExecution().getJobInstance().getJobName()), e9);
                    stepExecution.addFailureException(e9);
                }
                this.doExecutionRelease();
                if (logger.isDebugEnabled()) {
                    logger.debug("Step execution complete: " + stepExecution.getSummary());
                }
            }
        }
    }

    protected void doExecutionRelease() {
        StepSynchronizationManager.release();
    }

    protected void doExecutionRegistration(StepExecution stepExecution) {
        StepSynchronizationManager.register(stepExecution);
    }

    private static BatchStatus determineBatchStatus(Throwable e) {
        if (e instanceof JobInterruptedException || e.getCause() instanceof JobInterruptedException) {
            return BatchStatus.STOPPED;
        }
        return BatchStatus.FAILED;
    }

    public void registerStepExecutionListener(StepExecutionListener listener) {
        this.stepExecutionListener.register(listener);
    }

    public void setStepExecutionListeners(StepExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.registerStepExecutionListener(listeners[i]);
        }
    }

    protected StepExecutionListener getCompositeListener() {
        return this.stepExecutionListener;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    protected JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public String toString() {
        return ClassUtils.getShortName(this.getClass()) + ": [name=" + this.name + "]";
    }

    private ExitStatus getDefaultExitStatusForFailure(Throwable ex) {
        ExitStatus exitStatus = ex instanceof JobInterruptedException || ex.getCause() instanceof JobInterruptedException ? ExitStatus.STOPPED.addExitDescription(JobInterruptedException.class.getName()) : (ex instanceof NoSuchJobException || ex.getCause() instanceof NoSuchJobException ? new ExitStatus("NO_SUCH_JOB", ex.getClass().getName()) : ExitStatus.FAILED.addExitDescription(ex));
        return exitStatus;
    }
}

