/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.config.JpaMetamodelMappingContextFactoryBean;
import org.springframework.data.jpa.repository.support.DefaultJpaContext;
import org.springframework.data.jpa.repository.support.EntityManagerBeanDefinitionRegistrarPostProcessor;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.util.StringUtils;

public class JpaRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    private static final Class<?> PAB_POST_PROCESSOR = PersistenceAnnotationBeanPostProcessor.class;
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    private static final String ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE = "enableDefaultTransactions";

    @Override
    public String getModuleName() {
        return "JPA";
    }

    @Override
    public String getRepositoryFactoryClassName() {
        return JpaRepositoryFactoryBean.class.getName();
    }

    @Override
    protected String getModulePrefix() {
        return this.getModuleName().toLowerCase(Locale.US);
    }

    @Override
    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Arrays.asList(Entity.class, MappedSuperclass.class);
    }

    @Override
    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(JpaRepository.class);
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        String transactionManagerRef = source.getAttribute("transactionManagerRef");
        builder.addPropertyValue(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME, transactionManagerRef == null ? DEFAULT_TRANSACTION_MANAGER_BEAN_NAME : transactionManagerRef);
        builder.addPropertyValue("entityManager", JpaRepositoryConfigExtension.getEntityManagerBeanDefinitionFor(source, source.getSource()));
        builder.addPropertyReference("mappingContext", "jpaMappingContext");
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, attributes.getBoolean(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE));
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        String enableDefaultTransactions = config.getAttribute(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE);
        if (StringUtils.hasText(enableDefaultTransactions)) {
            builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, enableDefaultTransactions);
        }
    }

    @Override
    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        Object source = config.getSource();
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered(new RootBeanDefinition(EntityManagerBeanDefinitionRegistrarPostProcessor.class), registry, "emBeanDefinitionRegistrarPostProcessor", source);
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered(new RootBeanDefinition(JpaMetamodelMappingContextFactoryBean.class), registry, "jpaMappingContext", source);
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered(new RootBeanDefinition(PAB_POST_PROCESSOR), registry, "org.springframework.context.annotation.internalPersistenceAnnotationProcessor", source);
        RootBeanDefinition contextDefinition = new RootBeanDefinition(DefaultJpaContext.class);
        contextDefinition.setAutowireMode(3);
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered(contextDefinition, registry, "jpaContext", source);
    }

    private static AbstractBeanDefinition getEntityManagerBeanDefinitionFor(RepositoryConfigurationSource config, Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition("org.springframework.orm.jpa.SharedEntityManagerCreator");
        builder.setFactoryMethod("createSharedEntityManager");
        builder.addConstructorArgReference(JpaRepositoryConfigExtension.getEntityManagerBeanRef(config));
        AbstractBeanDefinition bean = builder.getRawBeanDefinition();
        bean.setSource(source);
        return bean;
    }

    private static String getEntityManagerBeanRef(RepositoryConfigurationSource config) {
        String entityManagerFactoryRef = config == null ? null : config.getAttribute("entityManagerFactoryRef");
        return entityManagerFactoryRef == null ? "entityManagerFactory" : entityManagerFactoryRef;
    }
}

