/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.conn.ssl;

import com.amazonaws.http.conn.ssl.MasterSecretValidators;
import com.amazonaws.http.conn.ssl.ShouldClearSslSessionPredicate;
import com.amazonaws.http.conn.ssl.TLSProtocol;
import com.amazonaws.internal.SdkMetricsSocket;
import com.amazonaws.internal.SdkSSLMetricsSocket;
import com.amazonaws.internal.SdkSSLSocket;
import com.amazonaws.internal.SdkSocket;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.util.JavaVersionParser;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpParams;

@ThreadSafe
public class SdkTLSSocketFactory
extends SSLSocketFactory {
    private static final Log LOG = LogFactory.getLog(SdkTLSSocketFactory.class);
    private final SSLContext sslContext;
    private final MasterSecretValidators.MasterSecretValidator masterSecretValidator;
    private final ShouldClearSslSessionPredicate shouldClearSslSessionsPredicate;

    public SdkTLSSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        super(sslContext, hostnameVerifier);
        if (sslContext == null) {
            throw new IllegalArgumentException("sslContext must not be null. Use SSLContext.getDefault() if you are unsure.");
        }
        this.sslContext = sslContext;
        this.masterSecretValidator = MasterSecretValidators.getMasterSecretValidator();
        this.shouldClearSslSessionsPredicate = new ShouldClearSslSessionPredicate(JavaVersionParser.getCurrentJavaVersion());
    }

    @Override
    protected final void prepareSocket(SSLSocket socket) {
        Object[] supported = socket.getSupportedProtocols();
        Object[] enabled = socket.getEnabledProtocols();
        if (LOG.isDebugEnabled()) {
            LOG.debug("socket.getSupportedProtocols(): " + Arrays.toString(supported) + ", socket.getEnabledProtocols(): " + Arrays.toString(enabled));
        }
        ArrayList<Object> target = new ArrayList<Object>();
        if (supported != null) {
            TLSProtocol[] values = TLSProtocol.values();
            for (int i = 0; i < values.length; ++i) {
                String pname = values[i].getProtocolName();
                if (!this.existsIn(pname, (String[])supported)) continue;
                target.add(pname);
            }
        }
        if (enabled != null) {
            for (Object pname : enabled) {
                if (target.contains(pname)) continue;
                target.add(pname);
            }
        }
        if (target.size() > 0) {
            Object[] enabling = target.toArray(new String[target.size()]);
            socket.setEnabledProtocols((String[])enabling);
            if (LOG.isDebugEnabled()) {
                LOG.debug("TLS protocol enabled for SSL handshake: " + Arrays.toString(enabling));
            }
        }
    }

    private boolean existsIn(String element, String[] a) {
        for (String s : a) {
            if (!element.equals(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("connecting to " + remoteAddress.getAddress() + ":" + remoteAddress.getPort());
        }
        try {
            Socket connectedSocket = super.connectSocket(socket, remoteAddress, localAddress, params);
            if (!this.masterSecretValidator.isMasterSecretValid(connectedSocket)) {
                throw this.log(new IllegalStateException("Invalid SSL master secret"));
            }
        }
        catch (SSLException sslEx) {
            if (this.shouldClearSslSessionsPredicate.test(sslEx)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("connection failed due to SSL error, clearing TLS session cache", sslEx);
                }
                this.clearSessionCache(this.sslContext.getClientSessionContext(), remoteAddress);
            }
            throw sslEx;
        }
        if (socket instanceof SSLSocket) {
            SdkSSLSocket sslSocket = new SdkSSLSocket((SSLSocket)socket);
            return AwsSdkMetrics.isHttpSocketReadMetricEnabled() ? new SdkSSLMetricsSocket(sslSocket) : sslSocket;
        }
        SdkSocket sdkSocket = new SdkSocket(socket);
        return AwsSdkMetrics.isHttpSocketReadMetricEnabled() ? new SdkMetricsSocket(sdkSocket) : sdkSocket;
    }

    private void clearSessionCache(SSLSessionContext sessionContext, InetSocketAddress remoteAddress) {
        String hostName = remoteAddress.getHostName();
        int port = remoteAddress.getPort();
        Enumeration<byte[]> ids = sessionContext.getIds();
        if (ids == null) {
            return;
        }
        while (ids.hasMoreElements()) {
            byte[] id = ids.nextElement();
            SSLSession session = sessionContext.getSession(id);
            if (session == null || session.getPeerHost() == null || !session.getPeerHost().equalsIgnoreCase(hostName) || session.getPeerPort() != port) continue;
            session.invalidate();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Invalidated session " + session);
        }
    }

    private <T extends Throwable> T log(T t) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("", t);
        }
        return t;
    }
}

