/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk.writer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.duracloud.chunk.ChunkableContent;
import org.duracloud.chunk.error.ContentNotAddedException;
import org.duracloud.chunk.error.NotFoundException;
import org.duracloud.chunk.manifest.ChunksManifest;
import org.duracloud.chunk.stream.ChunkInputStream;
import org.duracloud.chunk.stream.KnownLengthInputStream;
import org.duracloud.chunk.writer.AddContentResult;
import org.duracloud.chunk.writer.ContentWriter;
import org.duracloud.client.ContentStore;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.common.util.IOUtil;
import org.duracloud.error.ContentStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuracloudContentWriter
implements ContentWriter {
    private final Logger log = LoggerFactory.getLogger(DuracloudContentWriter.class);
    private ContentStore contentStore;
    private String username;
    private Set<String> existingSpaces = new HashSet<String>();
    private List<AddContentResult> results = new ArrayList<AddContentResult>();
    private ChecksumUtil checksumUtil = new ChecksumUtil(ChecksumUtil.Algorithm.MD5);
    private boolean throwOnError = false;
    private boolean jumpStart = false;
    private static int DEFAULT_MAX_RETRIES = 4;
    private static int DEFAULT_WAIT_IN_MS_BETWEEN_RETRIES = 1000;
    private int maxRetries = DEFAULT_MAX_RETRIES;
    private int waitInMsBetweenRetries = DEFAULT_MAX_RETRIES;

    public DuracloudContentWriter(ContentStore contentStore, String username) {
        this(contentStore, username, DEFAULT_MAX_RETRIES, DEFAULT_WAIT_IN_MS_BETWEEN_RETRIES);
    }

    public DuracloudContentWriter(ContentStore contentStore, String username, int maxRetries, int waitInMsBetweenRetries) {
        this.contentStore = contentStore;
        this.username = username;
        this.maxRetries = maxRetries;
        this.waitInMsBetweenRetries = waitInMsBetweenRetries;
    }

    public DuracloudContentWriter(ContentStore contentStore, String username, boolean throwOnError, boolean jumpStart) {
        this(contentStore, username, throwOnError, jumpStart, DEFAULT_MAX_RETRIES, DEFAULT_WAIT_IN_MS_BETWEEN_RETRIES);
    }

    public DuracloudContentWriter(ContentStore contentStore, String username, boolean throwOnError, boolean jumpStart, int maxRetries, int waitInMsBetweenRetries) {
        this(contentStore, username, maxRetries, waitInMsBetweenRetries);
        this.throwOnError = throwOnError;
        this.jumpStart = jumpStart;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public List<AddContentResult> getResults() {
        return this.results;
    }

    @Override
    public void ignore(String spaceId, String contentId, long contentSize) {
        AddContentResult result = new AddContentResult(spaceId, contentId, contentSize);
        result.setState(AddContentResult.State.IGNORED);
        this.results.add(result);
    }

    @Override
    public ChunksManifest write(String spaceId, ChunkableContent chunkable, Map<String, String> contentProperties) throws NotFoundException {
        return this.write(spaceId, chunkable, contentProperties, true);
    }

    private ChunksManifest write(String spaceId, ChunkableContent chunkable, Map<String, String> contentProperties, boolean lastAttempt) throws NotFoundException {
        this.log.debug("write: " + spaceId);
        this.createSpaceIfNotExist(spaceId);
        boolean errorsExist = false;
        for (ChunkInputStream chunk : chunkable) {
            this.writeChunk(spaceId, chunk);
            errorsExist = this.errorsExist();
            if (!errorsExist) continue;
            break;
        }
        ChunksManifest manifest = chunkable.finalizeManifest();
        if (!errorsExist) {
            this.addManifest(spaceId, manifest, contentProperties, lastAttempt);
        }
        this.log.debug("written: " + spaceId + ", " + manifest.getManifestId());
        return manifest;
    }

    protected boolean errorsExist() {
        boolean containsErrors = false;
        for (AddContentResult result : this.results) {
            if (!result.getState().equals((Object)AddContentResult.State.ERROR)) continue;
            containsErrors = true;
            break;
        }
        return containsErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChunk(final String spaceId, final ChunkInputStream chunk) throws NotFoundException {
        block6: {
            final String chunkId = chunk.getChunkId();
            final File chunkFile = IOUtil.writeStreamToFile(chunk);
            try {
                final String chunkChecksum = this.getChunkChecksum(chunkFile);
                if (!this.jumpStart && this.chunkInStorage(spaceId, chunkId, chunkChecksum)) break block6;
                try {
                    this.createRetrier().execute(new Retriable(){
                        private int attempt = 0;

                        @Override
                        public Object retry() throws Exception {
                            ++this.attempt;
                            try (FileInputStream chunkStream = new FileInputStream(chunkFile);){
                                ChunkInputStream chunkFileStream = new ChunkInputStream(chunkId, chunkStream, chunkFile.length(), chunk.md5Preserved());
                                DuracloudContentWriter.this.writeSingle(spaceId, chunkChecksum, chunkFileStream, this.attempt == DuracloudContentWriter.this.getMaxRetries() + 1);
                            }
                            return "";
                        }
                    });
                }
                catch (Exception e) {
                    String err = "Failed to store chunk with ID " + chunkId + " in space " + spaceId + " after " + this.getMaxRetries() + " attempts. Last error: " + e.getMessage();
                    throw new DuraCloudRuntimeException(err, e);
                }
            }
            finally {
                if (null != chunkFile && chunkFile.exists()) {
                    FileUtils.deleteQuietly(chunkFile);
                }
            }
        }
    }

    private String getChunkChecksum(File chunkFile) {
        try {
            return this.checksumUtil.generateChecksum(chunkFile);
        }
        catch (IOException e) {
            throw new DuraCloudRuntimeException("Unable to generate checksum for file " + chunkFile + " due to: " + e.getMessage());
        }
    }

    protected void setChecksumUtil(ChecksumUtil checksumUtil) {
        this.checksumUtil = checksumUtil;
    }

    private boolean chunkInStorage(String spaceId, String contentId, String checksum) {
        try {
            if (this.contentStore.contentExists(spaceId, contentId)) {
                Map<String, String> props = this.contentStore.getContentProperties(spaceId, contentId);
                String dcChecksum = props.get("content-checksum");
                return null != checksum && null != dcChecksum && checksum.equals(dcChecksum);
            }
            return false;
        }
        catch (ContentStoreException e) {
            return false;
        }
    }

    @Override
    public ChunksManifest write(String spaceId, ChunkableContent chunkable) throws NotFoundException {
        return this.write(spaceId, chunkable, null);
    }

    @Override
    public String writeSingle(String spaceId, String chunkChecksum, ChunkInputStream chunk, Map<String, String> properties) throws NotFoundException {
        this.log.debug("writeSingle: " + spaceId + ", " + chunk.getChunkId());
        this.createSpaceIfNotExist(spaceId);
        this.addChunk(spaceId, chunkChecksum, chunk, properties, true);
        this.log.debug("written: " + spaceId + ", " + chunk.getChunkId());
        return chunk.getMD5();
    }

    @Override
    public String writeSingle(String spaceId, String chunkChecksum, ChunkInputStream chunk) throws NotFoundException {
        return this.writeSingle(spaceId, chunkChecksum, chunk, true);
    }

    private String writeSingle(String spaceId, String chunkChecksum, ChunkInputStream chunk, boolean lastAttempt) throws NotFoundException {
        this.log.debug("writeSingle: " + spaceId + ", " + chunk.getChunkId());
        this.createSpaceIfNotExist(spaceId);
        this.addChunk(spaceId, chunkChecksum, chunk, null, lastAttempt);
        this.log.debug("written: " + spaceId + ", " + chunk.getChunkId());
        return chunk.getMD5();
    }

    private void addChunk(String spaceId, String chunkChecksum, ChunkInputStream chunk, Map<String, String> properties, boolean lastAttempt) {
        String chunkId = chunk.getChunkId();
        this.log.debug("addChunk: " + spaceId + ", " + chunkId);
        this.addContentThenReport(spaceId, chunkId, chunk, chunk.getChunkSize(), chunk.getMimetype(), chunkChecksum, properties, lastAttempt);
    }

    private void addManifest(String spaceId, ChunksManifest manifest, Map<String, String> properties, boolean lastAttempt) {
        String manifestId = manifest.getManifestId();
        this.log.debug("addManifest: " + spaceId + ", " + manifestId);
        try {
            this.createRetrier().execute(() -> {
                try (KnownLengthInputStream manifestBody = manifest.getBody();){
                    String manifestChecksum = this.checksumUtil.generateChecksum(manifest.getBody());
                    int manifestLength = manifestBody.getLength();
                    this.addContentThenReport(spaceId, manifestId, manifestBody, manifestLength, manifest.getMimetype(), manifestChecksum, properties, lastAttempt);
                }
                return "";
            });
        }
        catch (Exception e) {
            String err = "Failed to add manifest " + manifestId + " afert multiple retries: " + e.getMessage();
            throw new DuraCloudRuntimeException(err, e);
        }
    }

    private Retrier createRetrier() {
        return new Retrier(this.maxRetries, this.waitInMsBetweenRetries, 1);
    }

    private void addContentThenReport(String spaceId, String contentId, InputStream contentStream, long contentSize, String contentMimetype, String contentChecksum, Map<String, String> properties, boolean lastAttempt) {
        AddContentResult result = new AddContentResult(spaceId, contentId, contentSize);
        String md5 = null;
        try {
            md5 = this.addContent(spaceId, contentId, contentStream, contentSize, contentMimetype, contentChecksum, properties);
        }
        catch (ContentNotAddedException e) {
            if (this.throwOnError) {
                String err = "Content not added due to: " + e.getMessage();
                throw new DuraCloudRuntimeException(err, e);
            }
            if (lastAttempt) {
                result.setState(AddContentResult.State.ERROR);
            }
            String err = "Content not added due to: " + e.getMessage();
            throw new DuraCloudRuntimeException(err, e);
        }
        if (!this.throwOnError) {
            if (md5 != null) {
                result.setMd5(md5);
                result.setState(AddContentResult.State.SUCCESS);
            }
            this.results.add(result);
        }
    }

    private String addContent(String spaceId, String contentId, InputStream contentStream, long contentSize, String contentMimetype, String contentChecksum, Map<String, String> properties) throws ContentNotAddedException {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        if (!properties.containsKey("creator")) {
            properties.put("creator", this.username);
        }
        try {
            return this.contentStore.addContent(spaceId, contentId, contentStream, contentSize, contentMimetype, contentChecksum, properties);
        }
        catch (ContentStoreException e) {
            this.log.error(e.getFormattedMessage(), e);
            throw new ContentNotAddedException(spaceId, contentId, e);
        }
        catch (Exception ex) {
            this.log.error("Error adding content:" + ex.getMessage(), ex);
            throw new ContentNotAddedException(spaceId, contentId, ex);
        }
    }

    private void createSpaceIfNotExist(String spaceId) throws NotFoundException {
        boolean exists;
        if (this.existingSpaces.contains(spaceId)) {
            return;
        }
        if (!this.spaceExists(spaceId)) {
            this.createSpace(spaceId);
        }
        int tries = 0;
        while (!(exists = this.spaceExists(spaceId)) && tries++ < 10) {
            this.sleep(1000L);
        }
        if (!exists) {
            throw new NotFoundException("Space not found: " + spaceId);
        }
        this.existingSpaces.add(spaceId);
    }

    private void createSpace(String spaceId) {
        try {
            this.contentStore.createSpace(spaceId);
        }
        catch (ContentStoreException contentStoreException) {
            // empty catch block
        }
    }

    private boolean spaceExists(String spaceId) {
        try {
            return null != this.contentStore.getSpaceACLs(spaceId);
        }
        catch (ContentStoreException e) {
            return false;
        }
    }

    private void sleep(long napTime) {
        try {
            Thread.sleep(napTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

