/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.Subgraph;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class Jpa21Utils {
    private static final Method GET_ENTITY_GRAPH_METHOD;
    private static final boolean JPA21_AVAILABLE;

    private Jpa21Utils() {
    }

    public static Map<String, Object> tryGetFetchGraphHints(EntityManager em, JpaEntityGraph entityGraph, Class<?> entityType) {
        if (entityGraph == null) {
            return Collections.emptyMap();
        }
        EntityGraph<?> graph = Jpa21Utils.tryGetFetchGraph(em, entityGraph, entityType);
        if (graph == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(entityGraph.getType().getKey(), graph);
    }

    private static EntityGraph<?> tryGetFetchGraph(EntityManager em, JpaEntityGraph jpaEntityGraph, Class<?> entityType) {
        Assert.notNull(em, "EntityManager must not be null!");
        Assert.notNull(jpaEntityGraph, "EntityGraph must not be null!");
        Assert.notNull(entityType, "EntityType must not be null!");
        Assert.isTrue(JPA21_AVAILABLE, "The EntityGraph-Feature requires at least a JPA 2.1 persistence provider!");
        Assert.isTrue(GET_ENTITY_GRAPH_METHOD != null, "It seems that you have the JPA 2.1 API but a JPA 2.0 implementation on the classpath!");
        try {
            return em.getEntityGraph(jpaEntityGraph.getName());
        }
        catch (Exception ex) {
            return Jpa21Utils.createDynamicEntityGraph(em, jpaEntityGraph, entityType);
        }
    }

    private static EntityGraph<?> createDynamicEntityGraph(EntityManager em, JpaEntityGraph jpaEntityGraph, Class<?> entityType) {
        Assert.notNull(em, "EntityManager must not be null!");
        Assert.notNull(jpaEntityGraph, "JpaEntityGraph must not be null!");
        Assert.notNull(entityType, "Entity type must not be null!");
        Assert.isTrue(jpaEntityGraph.isAdHocEntityGraph(), "The given " + jpaEntityGraph + " is not dynamic!");
        EntityGraph<?> entityGraph = em.createEntityGraph(entityType);
        Jpa21Utils.configureFetchGraphFrom(jpaEntityGraph, entityGraph);
        return entityGraph;
    }

    static void configureFetchGraphFrom(JpaEntityGraph jpaEntityGraph, EntityGraph<?> entityGraph) {
        ArrayList<String> attributePaths = new ArrayList<String>(jpaEntityGraph.getAttributePaths());
        Collections.sort(attributePaths);
        Collections.reverse(attributePaths);
        for (String path : attributePaths) {
            if (!path.contains(".")) {
                entityGraph.addAttributeNodes(path);
                continue;
            }
            String[] pathComponents = StringUtils.delimitedListToStringArray(path, ".");
            Subgraph parent = null;
            for (int c = 0; c < pathComponents.length - 1; ++c) {
                parent = c == 0 ? entityGraph.addSubgraph(pathComponents[c]) : parent.addSubgraph(pathComponents[c]);
            }
            parent.addAttributeNodes(pathComponents[pathComponents.length - 1]);
        }
    }

    static {
        JPA21_AVAILABLE = ClassUtils.isPresent("javax.persistence.NamedEntityGraph", Jpa21Utils.class.getClassLoader());
        GET_ENTITY_GRAPH_METHOD = JPA21_AVAILABLE ? ReflectionUtils.findMethod(EntityManager.class, "getEntityGraph", String.class) : null;
    }
}

