/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class QueryUtils {
    public static final String COUNT_QUERY_STRING = "select count(%s) from %s x";
    public static final String DELETE_ALL_QUERY_STRING = "delete from %s x";
    private static final String DEFAULT_ALIAS = "x";
    private static final String COUNT_REPLACEMENT_TEMPLATE = "select count(%s) $5$6$7";
    private static final String SIMPLE_COUNT_VALUE = "$2";
    private static final String COMPLEX_COUNT_VALUE = "$3$6";
    private static final String ORDER_BY_PART = "(?iu)\\s+order\\s+by\\s+.*$";
    private static final Pattern ALIAS_MATCH;
    private static final Pattern COUNT_MATCH;
    private static final String IDENTIFIER = "[\\p{Lu}\\P{InBASIC_LATIN}\\p{Alnum}._$]+";
    private static final String IDENTIFIER_GROUP;
    private static final String JOIN;
    private static final Pattern JOIN_PATTERN;
    private static final String EQUALS_CONDITION_STRING = "%s.%s = :%s";
    private static final Pattern ORDER_BY;
    private static final Pattern NAMED_PARAMETER;
    private static final Pattern CONSTRUCTOR_EXPRESSION;
    private static final Map<Attribute.PersistentAttributeType, Class<? extends Annotation>> ASSOCIATION_TYPES;
    private static final int QUERY_JOIN_ALIAS_GROUP_INDEX = 2;
    private static final int VARIABLE_NAME_GROUP_INDEX = 4;

    private QueryUtils() {
    }

    public static String getExistsQueryString(String entityName, String countQueryPlaceHolder, Iterable<String> idAttributes) {
        StringBuilder sb = new StringBuilder(String.format(COUNT_QUERY_STRING, countQueryPlaceHolder, entityName));
        sb.append(" WHERE ");
        for (String idAttribute : idAttributes) {
            sb.append(String.format(EQUALS_CONDITION_STRING, DEFAULT_ALIAS, idAttribute, idAttribute));
            sb.append(" AND ");
        }
        sb.append("1 = 1");
        return sb.toString();
    }

    public static String getQueryString(String template, String entityName) {
        Assert.hasText(entityName, "Entity name must not be null or empty!");
        return String.format(template, entityName);
    }

    public static String applySorting(String query, Sort sort) {
        return QueryUtils.applySorting(query, sort, DEFAULT_ALIAS);
    }

    public static String applySorting(String query, Sort sort, String alias) {
        Assert.hasText(query);
        if (null == sort || !sort.iterator().hasNext()) {
            return query;
        }
        StringBuilder builder = new StringBuilder(query);
        if (!ORDER_BY.matcher(query).matches()) {
            builder.append(" order by ");
        } else {
            builder.append(", ");
        }
        Set<String> aliases = QueryUtils.getOuterJoinAliases(query);
        for (Sort.Order order : sort) {
            builder.append(QueryUtils.getOrderClause(aliases, alias, order)).append(", ");
        }
        builder.delete(builder.length() - 2, builder.length());
        return builder.toString();
    }

    private static String getOrderClause(Set<String> joinAliases, String alias, Sort.Order order) {
        String property = order.getProperty();
        boolean qualifyReference = !property.contains("(");
        for (String joinAlias : joinAliases) {
            if (!property.startsWith(joinAlias.concat("."))) continue;
            qualifyReference = false;
            break;
        }
        String reference = qualifyReference ? String.format("%s.%s", alias, property) : property;
        String wrapped = order.isIgnoreCase() ? String.format("lower(%s)", reference) : reference;
        return String.format("%s %s", wrapped, QueryUtils.toJpaDirection(order));
    }

    static Set<String> getOuterJoinAliases(String query) {
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = JOIN_PATTERN.matcher(query);
        while (matcher.find()) {
            String alias = matcher.group(2);
            if (!StringUtils.hasText(alias)) continue;
            result.add(alias);
        }
        return result;
    }

    private static String toJpaDirection(Sort.Order order) {
        return order.getDirection().name().toLowerCase(Locale.US);
    }

    public static String detectAlias(String query) {
        Matcher matcher = ALIAS_MATCH.matcher(query);
        return matcher.find() ? matcher.group(2) : null;
    }

    public static <T> Query applyAndBind(String queryString, Iterable<T> entities, EntityManager entityManager) {
        Assert.notNull(queryString);
        Assert.notNull(entities);
        Assert.notNull(entityManager);
        Iterator<T> iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return entityManager.createQuery(queryString);
        }
        String alias = QueryUtils.detectAlias(queryString);
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" where");
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            builder.append(String.format(" %s = ?%d", alias, ++i));
            if (!iterator.hasNext()) continue;
            builder.append(" or");
        }
        Query query = entityManager.createQuery(builder.toString());
        iterator = entities.iterator();
        i = 0;
        while (iterator.hasNext()) {
            query.setParameter(++i, iterator.next());
        }
        return query;
    }

    public static String createCountQueryFor(String originalQuery) {
        return QueryUtils.createCountQueryFor(originalQuery, null);
    }

    public static String createCountQueryFor(String originalQuery, String countProjection) {
        Assert.hasText(originalQuery, "OriginalQuery must not be null or empty!");
        Matcher matcher = COUNT_MATCH.matcher(originalQuery);
        String countQuery = null;
        if (countProjection == null) {
            String variable = matcher.matches() ? matcher.group(4) : null;
            boolean useVariable = variable != null && StringUtils.hasText(variable) && !variable.startsWith("new") && !variable.startsWith("count(") && !variable.contains(",");
            String replacement = useVariable ? SIMPLE_COUNT_VALUE : COMPLEX_COUNT_VALUE;
            countQuery = matcher.replaceFirst(String.format(COUNT_REPLACEMENT_TEMPLATE, replacement));
        } else {
            countQuery = matcher.replaceFirst(String.format(COUNT_REPLACEMENT_TEMPLATE, countProjection));
        }
        return countQuery.replaceFirst(ORDER_BY_PART, "");
    }

    public static boolean hasNamedParameter(Query query) {
        for (Parameter<?> parameter : query.getParameters()) {
            if (parameter.getName() == null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNamedParameter(String query) {
        return StringUtils.hasText(query) && NAMED_PARAMETER.matcher(query).find();
    }

    public static List<Order> toOrders(Sort sort, Root<?> root, CriteriaBuilder cb) {
        ArrayList<Order> orders = new ArrayList<Order>();
        if (sort == null) {
            return orders;
        }
        Assert.notNull(root);
        Assert.notNull(cb);
        for (Sort.Order order : sort) {
            orders.add(QueryUtils.toJpaOrder(order, root, cb));
        }
        return orders;
    }

    public static boolean hasConstructorExpression(String query) {
        Assert.hasText(query, "Query must not be null or empty!");
        return CONSTRUCTOR_EXPRESSION.matcher(query).find();
    }

    private static Order toJpaOrder(Sort.Order order, Root<?> root, CriteriaBuilder cb) {
        PropertyPath property = PropertyPath.from(order.getProperty(), root.getJavaType());
        Expression<String> expression = QueryUtils.toExpressionRecursively(root, property);
        if (order.isIgnoreCase() && String.class.equals(expression.getJavaType())) {
            Expression<String> lower = cb.lower(expression);
            return order.isAscending() ? cb.asc(lower) : cb.desc(lower);
        }
        return order.isAscending() ? cb.asc(expression) : cb.desc(expression);
    }

    static <T> Expression<T> toExpressionRecursively(From<?, ?> from, PropertyPath property) {
        Bindable propertyPathModel = null;
        Bindable model = from.getModel();
        String segment = property.getSegment();
        propertyPathModel = model instanceof ManagedType ? (Bindable)((Object)((ManagedType)((Object)model)).getAttribute(segment)) : from.get(segment).getModel();
        if (QueryUtils.requiresJoin(propertyPathModel, model instanceof PluralAttribute) && !QueryUtils.isAlreadyFetched(from, segment)) {
            Join<?, ?> join = QueryUtils.getOrCreateJoin(from, segment);
            return property.hasNext() ? QueryUtils.toExpressionRecursively(join, property.next()) : join;
        }
        Path<Object> path = from.get(segment);
        return property.hasNext() ? QueryUtils.toExpressionRecursively(path, property.next()) : path;
    }

    private static boolean requiresJoin(Bindable<?> propertyPathModel, boolean forPluralAttribute) {
        if (propertyPathModel == null && forPluralAttribute) {
            return true;
        }
        if (!(propertyPathModel instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)((Object)propertyPathModel);
        if (!ASSOCIATION_TYPES.containsKey((Object)attribute.getPersistentAttributeType())) {
            return false;
        }
        Class<? extends Annotation> associationAnnotation = ASSOCIATION_TYPES.get((Object)attribute.getPersistentAttributeType());
        if (associationAnnotation == null) {
            return true;
        }
        Member member = attribute.getJavaMember();
        if (!(member instanceof AnnotatedElement)) {
            return true;
        }
        Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)((Object)member), associationAnnotation);
        return annotation == null ? true : (Boolean)AnnotationUtils.getValue(annotation, "optional");
    }

    static Expression<Object> toExpressionRecursively(Path<Object> path, PropertyPath property) {
        Path<Object> result = path.get(property.getSegment());
        return property.hasNext() ? QueryUtils.toExpressionRecursively(result, property.next()) : result;
    }

    private static Join<?, ?> getOrCreateJoin(From<?, ?> from, String attribute) {
        for (Join<?, ?> join : from.getJoins()) {
            boolean sameName = join.getAttribute().getName().equals(attribute);
            if (!sameName || !join.getJoinType().equals((Object)JoinType.LEFT)) continue;
            return join;
        }
        return from.join(attribute, JoinType.LEFT);
    }

    private static boolean isAlreadyFetched(From<?, ?> from, String attribute) {
        for (Fetch f : from.getFetches()) {
            boolean sameName = f.getAttribute().getName().equals(attribute);
            if (!sameName || !f.getJoinType().equals((Object)JoinType.LEFT)) continue;
            return true;
        }
        return false;
    }

    static {
        IDENTIFIER_GROUP = String.format("(%s)", IDENTIFIER);
        JOIN = "join\\s[\\p{Lu}\\P{InBASIC_LATIN}\\p{Alnum}._$]+\\s(as\\s)?" + IDENTIFIER_GROUP;
        JOIN_PATTERN = Pattern.compile(JOIN, 2);
        ORDER_BY = Pattern.compile(".*order\\s+by\\s+.*", 2);
        NAMED_PARAMETER = Pattern.compile(":[\\p{Lu}\\P{InBASIC_LATIN}\\p{Alnum}._$]+|\\#[\\p{Lu}\\P{InBASIC_LATIN}\\p{Alnum}._$]+", 2);
        StringBuilder builder = new StringBuilder();
        builder.append("(?<=from)");
        builder.append("(?:\\s)+");
        builder.append(IDENTIFIER_GROUP);
        builder.append("(?:\\sas)*");
        builder.append("(?:\\s)+");
        builder.append("(\\w*)");
        ALIAS_MATCH = Pattern.compile(builder.toString(), 2);
        builder = new StringBuilder();
        builder.append("(select\\s+((distinct )?(.+?)?)\\s+)?(from\\s+");
        builder.append(IDENTIFIER);
        builder.append("(?:\\s+as)?\\s+)");
        builder.append(IDENTIFIER_GROUP);
        builder.append("(.*)");
        COUNT_MATCH = Pattern.compile(builder.toString(), 2);
        HashMap<Attribute.PersistentAttributeType, Class> persistentAttributeTypes = new HashMap<Attribute.PersistentAttributeType, Class>();
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.ONE_TO_ONE, OneToOne.class);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.ONE_TO_MANY, null);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.MANY_TO_ONE, ManyToOne.class);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.MANY_TO_MANY, null);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.ELEMENT_COLLECTION, null);
        ASSOCIATION_TYPES = Collections.unmodifiableMap(persistentAttributeTypes);
        builder = new StringBuilder();
        builder.append("select");
        builder.append("\\s+");
        builder.append("new");
        builder.append("\\s+");
        builder.append(IDENTIFIER);
        builder.append("\\s*");
        builder.append("\\(");
        builder.append(".*");
        builder.append("\\)");
        CONSTRUCTOR_EXPRESSION = Pattern.compile(builder.toString(), 2);
    }
}

