/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.repository.config.RepositoryComponentProvider;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.util.Assert;

public abstract class RepositoryConfigurationSourceSupport
implements RepositoryConfigurationSource {
    protected static final String DEFAULT_REPOSITORY_IMPL_POSTFIX = "Impl";
    private final Environment environment;

    public RepositoryConfigurationSourceSupport(Environment environment) {
        Assert.notNull(environment, "Environment must not be null!");
        this.environment = environment;
    }

    @Override
    public Collection<BeanDefinition> getCandidates(ResourceLoader loader) {
        RepositoryComponentProvider scanner = new RepositoryComponentProvider(this.getIncludeFilters());
        scanner.setConsiderNestedRepositoryInterfaces(this.shouldConsiderNestedRepositories());
        scanner.setResourceLoader(loader);
        scanner.setEnvironment(this.environment);
        for (TypeFilter filter : this.getExcludeFilters()) {
            scanner.addExcludeFilter(filter);
        }
        HashSet<BeanDefinition> result = new HashSet<BeanDefinition>();
        for (String basePackage : this.getBasePackages()) {
            Set<BeanDefinition> candidate = scanner.findCandidateComponents(basePackage);
            result.addAll(candidate);
        }
        return result;
    }

    protected Iterable<TypeFilter> getExcludeFilters() {
        return Collections.emptySet();
    }

    protected Iterable<TypeFilter> getIncludeFilters() {
        return Collections.emptySet();
    }

    public boolean shouldConsiderNestedRepositories() {
        return false;
    }
}

