/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.db;

import java.text.MessageFormat;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.duracloud.common.db.jpa.JpaConfigurationUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaRepositories(basePackages={"org.duracloud.snapshot.db"}, entityManagerFactoryRef="entityManagerFactory", transactionManagerRef="transactionManager")
@EnableTransactionManagement
public class SnapshotDatabaseConfig {
    public static final String SNAPSHOT_REPO_DATA_SOURCE_BEAN = "dataSource";
    public static final String TRANSACTION_MANAGER_BEAN = "transactionManager";
    public static final String ENTITY_MANAGER_FACTORY_BEAN = "entityManagerFactory";
    @Autowired
    private Environment env;

    @Bean(name={"dataSource"}, destroyMethod="close")
    public BasicDataSource snapshotDataSource() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName("com.mysql.jdbc.Driver");
        dataSource.setUrl(MessageFormat.format("jdbc:mysql://{0}:{1}/{2}?useLegacyDatetimeCode=false&serverTimezone=GMT&characterEncoding=utf8&characxterSetResults=utf8", this.env.getProperty("snapshot.db.host", "localhost"), this.env.getProperty("snapshot.db.port", "3306"), this.env.getProperty("snapshot.db.name", "snapshot")));
        dataSource.setUsername(this.env.getProperty("snapshot.db.user", "user"));
        dataSource.setPassword(this.env.getProperty("snapshot.db.pass", "pass"));
        dataSource.setTestOnBorrow(true);
        dataSource.setValidationQuery("SELECT 1");
        dataSource.setValidationQueryTimeout(10);
        dataSource.addConnectionProperty("hibernate.connection.release_mode", "after_transaction");
        return dataSource;
    }

    @Bean(name={"transactionManager"})
    @Primary
    public PlatformTransactionManager snapshotTransactionManager(@Qualifier(value="entityManagerFactory") EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager tm = new JpaTransactionManager(entityManagerFactory);
        tm.setJpaDialect(new HibernateJpaDialect());
        return tm;
    }

    @Bean(name={"entityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean snapshotRepoEntityManagerFactory(@Qualifier(value="dataSource") DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean emf = new LocalContainerEntityManagerFactoryBean();
        emf.setDataSource(dataSource);
        emf.setPersistenceUnitName("snapshot-repo-pu");
        emf.setPackagesToScan("org.duracloud.snapshot");
        JpaConfigurationUtil.configureEntityManagerFactory(this.env, emf);
        return emf;
    }
}

