/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SimpleTransactionScope
implements Scope {
    @Override
    public Object get(String name, ObjectFactory<?> objectFactory) {
        Object scopedObject;
        ScopedObjectsHolder scopedObjects = (ScopedObjectsHolder)TransactionSynchronizationManager.getResource(this);
        if (scopedObjects == null) {
            scopedObjects = new ScopedObjectsHolder();
            TransactionSynchronizationManager.registerSynchronization(new CleanupSynchronization());
            TransactionSynchronizationManager.bindResource(this, scopedObjects);
        }
        if ((scopedObject = scopedObjects.scopedInstances.get(name)) == null) {
            scopedObject = objectFactory.getObject();
            scopedObjects.scopedInstances.put(name, scopedObject);
        }
        return scopedObject;
    }

    @Override
    public Object remove(String name) {
        ScopedObjectsHolder scopedObjects = (ScopedObjectsHolder)TransactionSynchronizationManager.getResource(this);
        if (scopedObjects != null) {
            scopedObjects.destructionCallbacks.remove(name);
            return scopedObjects.scopedInstances.remove(name);
        }
        return null;
    }

    @Override
    public void registerDestructionCallback(String name, Runnable callback) {
        ScopedObjectsHolder scopedObjects = (ScopedObjectsHolder)TransactionSynchronizationManager.getResource(this);
        if (scopedObjects != null) {
            scopedObjects.destructionCallbacks.put(name, callback);
        }
    }

    @Override
    public Object resolveContextualObject(String key) {
        return null;
    }

    @Override
    public String getConversationId() {
        return TransactionSynchronizationManager.getCurrentTransactionName();
    }

    private class CleanupSynchronization
    extends TransactionSynchronizationAdapter {
        private CleanupSynchronization() {
        }

        @Override
        public void afterCompletion(int status) {
            ScopedObjectsHolder scopedObjects = (ScopedObjectsHolder)TransactionSynchronizationManager.unbindResourceIfPossible(SimpleTransactionScope.this);
            for (Runnable callback : scopedObjects.destructionCallbacks.values()) {
                callback.run();
            }
        }
    }

    static class ScopedObjectsHolder {
        final Map<String, Object> scopedInstances = new HashMap<String, Object>();
        final Map<String, Runnable> destructionCallbacks = new LinkedHashMap<String, Runnable>();

        ScopedObjectsHolder() {
        }
    }
}

