/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.duracloud.common.collection.WriteOnlyStringSet;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.snapshot.db.model.SnapshotContentItem;
import org.duracloud.snapshot.dto.RestoreStatus;
import org.duracloud.snapshot.service.RestoreManager;
import org.duracloud.snapshot.service.impl.ManifestFileHelper;
import org.duracloud.snapshot.service.impl.PropertiesSerializer;
import org.duracloud.snapshot.service.impl.SpaceVerifier;
import org.duracloud.snapshot.service.impl.StepExecutionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ItemWriter;

public class SnapshotContentItemVerifier
extends StepExecutionSupport
implements ItemWriter<SnapshotContentItem>,
ItemWriteListener<SnapshotContentItem> {
    private Logger log = LoggerFactory.getLogger(SpaceVerifier.class);
    private File manifestFile;
    private String restoreId;
    private String snapshotName;
    private RestoreManager restoreManager;
    private WriteOnlyStringSet manifestSet;

    public SnapshotContentItemVerifier(String restoreId, File manifestFile, String snapshotName, RestoreManager restoreManager) {
        this.restoreId = restoreId;
        this.manifestFile = manifestFile;
        this.snapshotName = snapshotName;
        this.restoreManager = restoreManager;
    }

    @Override
    public void beforeWrite(List<? extends SnapshotContentItem> items) {
    }

    @Override
    public void afterWrite(List<? extends SnapshotContentItem> items) {
        int size = items.size();
        for (SnapshotContentItem snapshotContentItem : items) {
            if (!snapshotContentItem.getContentId().equals(".collection-snapshot.properties")) continue;
            --size;
        }
        this.addToItemsRead(size);
    }

    @Override
    public void onWriteError(Exception exception, List<? extends SnapshotContentItem> items) {
        this.addError(exception.getMessage());
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        super.beforeStep(stepExecution);
        this.resetContextState();
        try {
            this.manifestSet = ManifestFileHelper.loadManifestSetFromFile(this.manifestFile);
            new Retrier().execute(new Retriable(){

                @Override
                public Object retry() throws Exception {
                    RestoreStatus newStatus = RestoreStatus.VERIFYING_SNAPSHOT_REPO_AGAINST_MANIFEST;
                    SnapshotContentItemVerifier.this.restoreManager.transitionRestoreStatus(SnapshotContentItemVerifier.this.restoreId, newStatus, "");
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.addError("failed to transition status to " + (Object)((Object)RestoreStatus.VERIFYING_SNAPSHOT_REPO_AGAINST_MANIFEST) + ": " + ex.getMessage());
            stepExecution.addFailureException(ex);
        }
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        long snapshotItemCount = this.getItemsRead();
        if (snapshotItemCount == (long)this.manifestSet.size()) {
            this.log.debug("snapshot repo count matches manifest count: step_execution_id={} job_execution_id={} snapshot_name={}", stepExecution.getId(), stepExecution.getJobExecutionId(), this.snapshotName);
        } else {
            this.addError("snapshot (" + this.snapshotName + ") content item count (" + snapshotItemCount + ") does not match manifest count (" + this.manifestSet.size() + ")");
        }
        ExitStatus status = stepExecution.getExitStatus();
        List<String> errors = this.getErrors();
        if (errors.size() > 0) {
            status = status.and(ExitStatus.FAILED);
            for (String error : errors) {
                status = status.addExitDescription(error);
            }
            this.log.error("snapshot repo verification finished: step_execution_id={} job_execution_id={} snapshot_name={} status=\"{}\"", stepExecution.getId(), stepExecution.getJobExecutionId(), this.snapshotName, status);
            this.failExecution();
            this.resetContextState();
        } else {
            status = status.and(ExitStatus.COMPLETED);
        }
        return status;
    }

    @Override
    public void write(List<? extends SnapshotContentItem> items) throws Exception {
        for (SnapshotContentItem snapshotContentItem : items) {
            Map<String, String> props = PropertiesSerializer.deserialize(snapshotContentItem.getMetadata());
            String contentId = snapshotContentItem.getContentId();
            String checksum = props.get("content-checksum");
            if (contentId.equals(".collection-snapshot.properties") || this.manifestSet.contains(ManifestFileHelper.formatManifestSetString(contentId, checksum))) continue;
            this.addError(MessageFormat.format("Content item {0} with checksum {1} not found in manifest for snapshot {2}", contentId, checksum, this.snapshotName));
        }
    }
}

