/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml.stax;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.springframework.batch.item.xml.stax.AbstractEventWriterWrapper;

public class UnclosedElementCollectingEventWriter
extends AbstractEventWriterWrapper {
    private LinkedList<QName> unclosedElements = new LinkedList();

    public UnclosedElementCollectingEventWriter(XMLEventWriter wrappedEventWriter) {
        super(wrappedEventWriter);
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        if (event.isStartElement()) {
            this.unclosedElements.addLast(event.asStartElement().getName());
        } else if (event.isEndElement()) {
            this.unclosedElements.removeLast();
        }
        super.add(event);
    }

    public List<QName> getUnclosedElements() {
        return this.unclosedElements;
    }
}

