/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk.manifest.xml;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.duracloud.ChunkType;
import org.duracloud.ChunksManifestType;
import org.duracloud.ChunksType;
import org.duracloud.HeaderType;
import org.duracloud.SourceContentType;
import org.duracloud.chunk.manifest.ChunksManifestBean;

public class ManifestElementWriter {
    public static ChunksManifestType createChunksManifestElementFrom(ChunksManifestBean manifest) {
        ChunksManifestType manifestType = ChunksManifestType.Factory.newInstance();
        ManifestElementWriter.populateElementFromObject(manifestType, manifest);
        return manifestType;
    }

    private static void populateElementFromObject(ChunksManifestType manifestType, ChunksManifestBean manifest) {
        HeaderType headerType = manifestType.addNewHeader();
        ManifestElementWriter.populateHeaderType(headerType, manifest.getHeader());
        ChunksType chunksType = manifestType.addNewChunks();
        ManifestElementWriter.populateChunksType(chunksType, manifest.getEntries());
    }

    private static void populateHeaderType(HeaderType headerType, ChunksManifestBean.ManifestHeader header) {
        long size2;
        String md5;
        String mime;
        headerType.setSchemaVersion("0.2");
        SourceContentType sourceContentType = headerType.addNewSourceContent();
        String contentId = header.getSourceContentId();
        if (!StringUtils.isBlank(contentId)) {
            sourceContentType.setContentId(contentId);
        }
        if (!StringUtils.isBlank(mime = header.getSourceMimetype())) {
            sourceContentType.setMimetype(mime);
        }
        if (!StringUtils.isBlank(md5 = header.getSourceMD5())) {
            sourceContentType.setMd5(md5);
        }
        if ((size2 = header.getSourceByteSize()) > -1L) {
            sourceContentType.setByteSize(size2);
        }
    }

    private static void populateChunksType(ChunksType chunksType, List<ChunksManifestBean.ManifestEntry> entries2) {
        if (null != entries2 && entries2.size() > 0) {
            for (ChunksManifestBean.ManifestEntry entry : entries2) {
                int index;
                long size2;
                String md5;
                ChunkType chunkType = chunksType.addNewChunk();
                String chunkId = entry.getChunkId();
                if (!StringUtils.isBlank(chunkId)) {
                    chunkType.setChunkId(chunkId);
                }
                if (!StringUtils.isBlank(md5 = entry.getChunkMD5())) {
                    chunkType.setMd5(md5);
                }
                if ((size2 = entry.getByteSize()) > -1L) {
                    chunkType.setByteSize(size2);
                }
                if ((index = entry.getIndex()) <= -1) continue;
                chunkType.setIndex(index);
            }
        }
    }
}

