/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PreDestroy;
import org.duracloud.snapshot.service.Finalizer;
import org.duracloud.snapshot.service.RestoreManager;
import org.duracloud.snapshot.service.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FinalizerImpl
implements Finalizer {
    private static Logger log = LoggerFactory.getLogger(FinalizerImpl.class);
    private Timer timer;
    @Autowired
    private SnapshotManager snapshotManager;
    @Autowired
    private RestoreManager restoreManager;

    public void setSnapshotManager(SnapshotManager snapshotManager) {
        this.snapshotManager = snapshotManager;
    }

    public void setRestoreManager(RestoreManager restoreManager) {
        this.restoreManager = restoreManager;
    }

    @Override
    public void initialize(Integer pollingPeriodMs) {
        if (this.timer == null) {
            this.timer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        log.info("Launching periodic finalization...");
                        FinalizerImpl.this.snapshotManager.finalizeSnapshots();
                        FinalizerImpl.this.restoreManager.finalizeRestores();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            };
            if (pollingPeriodMs == null || pollingPeriodMs < 1) {
                pollingPeriodMs = DEFAULT_POLLING_PERIOD_MS;
            }
            this.timer.schedule(task, new Date(), (long)pollingPeriodMs.intValue());
            log.info("Finalization scheduled to run every " + pollingPeriodMs + " milliseconds.");
        }
    }

    @Override
    @PreDestroy
    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

