/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.fixed;

import java.util.Collection;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.list.FixedSizeList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.list.fixed.FixedSizeListIteratorAdapter;
import org.eclipse.collections.impl.list.mutable.AbstractMutableList;
import org.eclipse.collections.impl.utility.Iterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMemoryEfficientMutableList<T>
extends AbstractMutableList<T>
implements FixedSizeList<T>,
RandomAccess {
    @Override
    public FixedSizeList<T> clone() {
        return (FixedSizeList)super.clone();
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException("Cannot add to a fixed size list: " + this.getClass());
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Cannot add to a fixed size list: " + this.getClass());
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Cannot add to a fixed size list: " + this.getClass());
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Cannot add to a fixed size list: " + this.getClass());
    }

    @Override
    public boolean addAllIterable(Iterable<? extends T> iterable) {
        throw new UnsupportedOperationException("Cannot add to a fixed size list: " + this.getClass());
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot remove from a fixed size list: " + this.getClass());
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Cannot remove from a fixed size list: " + this.getClass());
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot remove from a fixed size list: " + this.getClass());
    }

    @Override
    public boolean removeAllIterable(Iterable<?> iterable) {
        throw new UnsupportedOperationException("Cannot remove from a fixed size list: " + this.getClass());
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException("Cannot remove from a fixed size list: " + this.getClass());
    }

    @Override
    public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        throw new UnsupportedOperationException("Cannot removeIfWith from a fixed size list: " + this.getClass());
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot remove from a fixed size list: " + this.getClass());
    }

    @Override
    public boolean retainAllIterable(Iterable<?> iterable) {
        throw new UnsupportedOperationException("Cannot remove from a fixed size list: " + this.getClass());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot clear a fixed size list: " + this.getClass());
    }

    @Override
    public FixedSizeList<T> toReversed() {
        FixedSizeList result = Lists.fixedSize.withAll(this);
        result.reverseThis();
        return result;
    }

    @Override
    public MutableList<T> subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    @Override
    public MutableList<T> without(T element) {
        if (this.contains(element)) {
            return Lists.fixedSize.ofAll(this.toList().without(element));
        }
        return this;
    }

    @Override
    public MutableList<T> withAll(Iterable<? extends T> elements) {
        if (Iterate.isEmpty(elements)) {
            return this;
        }
        return Lists.fixedSize.ofAll(this.toList().withAll(elements));
    }

    @Override
    public MutableList<T> withoutAll(Iterable<? extends T> elements) {
        if (Iterate.isEmpty(elements)) {
            return this;
        }
        return Lists.fixedSize.ofAll(this.toList().withoutAll(elements));
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new FixedSizeListIteratorAdapter(super.listIterator(index));
    }

    @Override
    public ListIterator<T> listIterator() {
        return new FixedSizeListIteratorAdapter(super.listIterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubList<T>
    extends AbstractMutableList.SubList<T> {
        private static final long serialVersionUID = 1L;

        protected SubList(AbstractMutableList<T> list, int fromIndex, int toIndex) {
            super(list, fromIndex, toIndex);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Cannot remove from a fixed size list: " + this.getClass());
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException("Cannot remove from a fixed size list: " + this.getClass());
        }

        @Override
        public boolean removeAllIterable(Iterable<?> iterable) {
            throw new UnsupportedOperationException("Cannot remove from a fixed size list: " + this.getClass());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException("Cannot remove from a fixed size list: " + this.getClass());
        }

        @Override
        public boolean retainAllIterable(Iterable<?> iterable) {
            throw new UnsupportedOperationException("Cannot remove from a fixed size list: " + this.getClass());
        }

        @Override
        public boolean removeIf(Predicate<? super T> predicate) {
            throw new UnsupportedOperationException("Cannot remove from a fixed size list: " + this.getClass());
        }

        @Override
        public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            throw new UnsupportedOperationException("Cannot removeIfWith from a fixed size list: " + this.getClass());
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            throw new UnsupportedOperationException("Cannot add to a fixed size list: " + this.getClass());
        }

        @Override
        public boolean addAllIterable(Iterable<? extends T> iterable) {
            throw new UnsupportedOperationException("Cannot add to a fixed size list: " + this.getClass());
        }
    }
}

