/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.listener.OrderedComposite;

public class CompositeSkipListener<T, S>
implements SkipListener<T, S> {
    private OrderedComposite<SkipListener<? super T, ? super S>> listeners = new OrderedComposite();

    public void setListeners(List<? extends SkipListener<? super T, ? super S>> listeners) {
        this.listeners.setItems(listeners);
    }

    public void register(SkipListener<? super T, ? super S> listener2) {
        this.listeners.add(listener2);
    }

    @Override
    public void onSkipInRead(Throwable t) {
        Iterator<SkipListener<T, S>> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            SkipListener<T, S> listener2 = iterator2.next();
            listener2.onSkipInRead(t);
        }
    }

    @Override
    public void onSkipInWrite(S item, Throwable t) {
        Iterator<SkipListener<T, S>> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            SkipListener<T, S> listener2 = iterator2.next();
            listener2.onSkipInWrite(item, t);
        }
    }

    @Override
    public void onSkipInProcess(T item, Throwable t) {
        Iterator<SkipListener<T, S>> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            SkipListener<T, S> listener2 = iterator2.next();
            listener2.onSkipInProcess(item, t);
        }
    }
}

