/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support.transaction;

import java.util.Stack;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class ResourcelessTransactionManager
extends AbstractPlatformTransactionManager {
    @Override
    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        ((ResourcelessTransaction)transaction).begin();
    }

    @Override
    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Committing resourceless transaction on [" + status.getTransaction() + "]");
        }
    }

    @Override
    protected Object doGetTransaction() throws TransactionException {
        Stack resources;
        ResourcelessTransaction transaction = new ResourcelessTransaction();
        if (!TransactionSynchronizationManager.hasResource(this)) {
            resources = new Stack();
            TransactionSynchronizationManager.bindResource(this, resources);
        } else {
            Stack stack;
            resources = stack = (Stack)TransactionSynchronizationManager.getResource(this);
        }
        resources.push(transaction);
        return transaction;
    }

    @Override
    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rolling back resourceless transaction on [" + status.getTransaction() + "]");
        }
    }

    @Override
    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        if (TransactionSynchronizationManager.hasResource(this)) {
            Stack stack = (Stack)TransactionSynchronizationManager.getResource(this);
            return stack.size() > 1;
        }
        return ((ResourcelessTransaction)transaction).isActive();
    }

    @Override
    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
    }

    @Override
    protected void doCleanupAfterCompletion(Object transaction) {
        Stack list;
        Stack resources = list = (Stack)TransactionSynchronizationManager.getResource(this);
        resources.clear();
        TransactionSynchronizationManager.unbindResource(this);
        ((ResourcelessTransaction)transaction).clear();
    }

    private static class ResourcelessTransaction {
        private boolean active = false;

        private ResourcelessTransaction() {
        }

        public boolean isActive() {
            return this.active;
        }

        public void begin() {
            this.active = true;
        }

        public void clear() {
            this.active = false;
        }
    }
}

