/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.util.Assert;

public class ParametersParameterAccessor
implements ParameterAccessor {
    private final Parameters<?, ?> parameters;
    private final List<Object> values;

    public ParametersParameterAccessor(Parameters<?, ?> parameters, Object[] values2) {
        Assert.notNull(parameters);
        Assert.notNull(values2);
        Assert.isTrue(parameters.getNumberOfParameters() == values2.length, "Invalid number of parameters given!");
        this.parameters = parameters;
        ArrayList<Object> unwrapped = new ArrayList<Object>(values2.length);
        for (Object element : (Object[])values2.clone()) {
            unwrapped.add(QueryExecutionConverters.unwrap(element));
        }
        this.values = unwrapped;
    }

    public Parameters<?, ?> getParameters() {
        return this.parameters;
    }

    @Override
    public Pageable getPageable() {
        if (!this.parameters.hasPageableParameter()) {
            return null;
        }
        return (Pageable)this.values.get(this.parameters.getPageableIndex());
    }

    @Override
    public Sort getSort() {
        if (this.parameters.hasSortParameter()) {
            return (Sort)this.values.get(this.parameters.getSortIndex());
        }
        if (this.parameters.hasPageableParameter() && this.getPageable() != null) {
            return this.getPageable().getSort();
        }
        return null;
    }

    @Override
    public Class<?> getDynamicProjection() {
        return this.parameters.hasDynamicProjection() ? (Class)this.values.get(this.parameters.getDynamicProjectionIndex()) : null;
    }

    protected <T> T getValue(int index) {
        return (T)this.values.get(index);
    }

    @Override
    public Object getBindableValue(int index) {
        return this.values.get(((Parameter)this.parameters.getBindableParameter(index)).getIndex());
    }

    @Override
    public boolean hasBindableNullValue() {
        for (Parameter parameter : this.parameters.getBindableParameters()) {
            if (this.values.get(parameter.getIndex()) != null) continue;
            return true;
        }
        return false;
    }

    public BindableParameterIterator iterator() {
        return new BindableParameterIterator(this);
    }

    private static class BindableParameterIterator
    implements Iterator<Object> {
        private final int bindableParameterCount;
        private final ParameterAccessor accessor;
        private int currentIndex = 0;

        public BindableParameterIterator(ParametersParameterAccessor accessor) {
            Assert.notNull(accessor, "ParametersParameterAccessor must not be null!");
            this.accessor = accessor;
            this.bindableParameterCount = ((Parameters)accessor.getParameters().getBindableParameters()).getNumberOfParameters();
        }

        @Override
        public Object next() {
            return this.accessor.getBindableValue(this.currentIndex++);
        }

        @Override
        public boolean hasNext() {
            return this.bindableParameterCount > this.currentIndex;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

