/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import java.io.Serializable;
import java.util.Map;

public class SendMessageBatchRequestEntry
implements Serializable,
Cloneable {
    private String id;
    private String messageBody;
    private Integer delaySeconds;
    private SdkInternalMap<String, MessageAttributeValue> messageAttributes;
    private String messageDeduplicationId;
    private String messageGroupId;

    public SendMessageBatchRequestEntry() {
    }

    public SendMessageBatchRequestEntry(String id, String messageBody) {
        this.setId(id);
        this.setMessageBody(messageBody);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public SendMessageBatchRequestEntry withId(String id) {
        this.setId(id);
        return this;
    }

    public void setMessageBody(String messageBody) {
        this.messageBody = messageBody;
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public SendMessageBatchRequestEntry withMessageBody(String messageBody) {
        this.setMessageBody(messageBody);
        return this;
    }

    public void setDelaySeconds(Integer delaySeconds) {
        this.delaySeconds = delaySeconds;
    }

    public Integer getDelaySeconds() {
        return this.delaySeconds;
    }

    public SendMessageBatchRequestEntry withDelaySeconds(Integer delaySeconds) {
        this.setDelaySeconds(delaySeconds);
        return this;
    }

    public Map<String, MessageAttributeValue> getMessageAttributes() {
        if (this.messageAttributes == null) {
            this.messageAttributes = new SdkInternalMap();
        }
        return this.messageAttributes;
    }

    public void setMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.messageAttributes = messageAttributes == null ? null : new SdkInternalMap<String, MessageAttributeValue>(messageAttributes);
    }

    public SendMessageBatchRequestEntry withMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.setMessageAttributes(messageAttributes);
        return this;
    }

    public SendMessageBatchRequestEntry addMessageAttributesEntry(String key, MessageAttributeValue value) {
        if (null == this.messageAttributes) {
            this.messageAttributes = new SdkInternalMap();
        }
        if (this.messageAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.messageAttributes.put(key, value);
        return this;
    }

    public SendMessageBatchRequestEntry clearMessageAttributesEntries() {
        this.messageAttributes = null;
        return this;
    }

    public void setMessageDeduplicationId(String messageDeduplicationId) {
        this.messageDeduplicationId = messageDeduplicationId;
    }

    public String getMessageDeduplicationId() {
        return this.messageDeduplicationId;
    }

    public SendMessageBatchRequestEntry withMessageDeduplicationId(String messageDeduplicationId) {
        this.setMessageDeduplicationId(messageDeduplicationId);
        return this;
    }

    public void setMessageGroupId(String messageGroupId) {
        this.messageGroupId = messageGroupId;
    }

    public String getMessageGroupId() {
        return this.messageGroupId;
    }

    public SendMessageBatchRequestEntry withMessageGroupId(String messageGroupId) {
        this.setMessageGroupId(messageGroupId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getMessageBody() != null) {
            sb.append("MessageBody: ").append(this.getMessageBody()).append(",");
        }
        if (this.getDelaySeconds() != null) {
            sb.append("DelaySeconds: ").append(this.getDelaySeconds()).append(",");
        }
        if (this.getMessageAttributes() != null) {
            sb.append("MessageAttributes: ").append(this.getMessageAttributes()).append(",");
        }
        if (this.getMessageDeduplicationId() != null) {
            sb.append("MessageDeduplicationId: ").append(this.getMessageDeduplicationId()).append(",");
        }
        if (this.getMessageGroupId() != null) {
            sb.append("MessageGroupId: ").append(this.getMessageGroupId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageBatchRequestEntry)) {
            return false;
        }
        SendMessageBatchRequestEntry other = (SendMessageBatchRequestEntry)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getMessageBody() == null ^ this.getMessageBody() == null) {
            return false;
        }
        if (other.getMessageBody() != null && !other.getMessageBody().equals(this.getMessageBody())) {
            return false;
        }
        if (other.getDelaySeconds() == null ^ this.getDelaySeconds() == null) {
            return false;
        }
        if (other.getDelaySeconds() != null && !other.getDelaySeconds().equals(this.getDelaySeconds())) {
            return false;
        }
        if (other.getMessageAttributes() == null ^ this.getMessageAttributes() == null) {
            return false;
        }
        if (other.getMessageAttributes() != null && !other.getMessageAttributes().equals(this.getMessageAttributes())) {
            return false;
        }
        if (other.getMessageDeduplicationId() == null ^ this.getMessageDeduplicationId() == null) {
            return false;
        }
        if (other.getMessageDeduplicationId() != null && !other.getMessageDeduplicationId().equals(this.getMessageDeduplicationId())) {
            return false;
        }
        if (other.getMessageGroupId() == null ^ this.getMessageGroupId() == null) {
            return false;
        }
        return other.getMessageGroupId() == null || other.getMessageGroupId().equals(this.getMessageGroupId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getMessageBody() == null ? 0 : this.getMessageBody().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getDelaySeconds() == null ? 0 : this.getDelaySeconds().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getMessageAttributes() == null ? 0 : this.getMessageAttributes().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getMessageDeduplicationId() == null ? 0 : this.getMessageDeduplicationId().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getMessageGroupId() == null ? 0 : this.getMessageGroupId().hashCode());
        return hashCode2;
    }

    public SendMessageBatchRequestEntry clone() {
        try {
            return (SendMessageBatchRequestEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

